# Fiber Bragg grating sensors for monitoring of physical parameters: a comprehensive review

Jasjot K. Sahota,\* Neena Gupta, and Divya Dhawan Punjab Engineering College (Deemed to be University), Department of Electronics and Communication Engineering, Chandigarh, Punjab, India

Abstract. Fiber Bragg grating has embraced the area of fiber optics since the early days of its discovery, and most fiber optic sensor systems today make use of fiber Bragg grating technology. Researchers have gained enormous attention in the field of fiber Bragg grating (FBG)-based sensing due to its inherent advantages, such as small size, fast response, distributed sensing, and immunity to the electromagnetic field. Fiber Bragg grating technology is popularly used in measurements of various physical parameters, such as pressure, temperature, and strain for civil engineering, industrial engineering, military, maritime, and aerospace applications. Nowadays, strong emphasis is given to structure health monitoring of various engineering and civil structures, which can be easily achieved with FBG-based sensors. Depending on the type of grating, FBG can be uniform, long, chirped, tilted or phase shifted having periodic perturbation of refractive index inside core of the optical fiber. Basic fundamentals of FBG and recent progress of fiber Bragg grating-based sensors used in various applications for temperature, pressure, liquid level, strain, and refractive index sensing have been reviewed. A major problem of temperature cross sensitivity that occurs in FBG-based sensing requires temperature compensation technique that has also been discussed in this paper. $©$ 2020 Society of Photo-Optical Instrumentation Engineers (SPIE) [DOI: 10.1117/1.OE.59.6.060901]

Keywords: displacement sensor; fiber Bragg gratings; pressure sensor; refractive index sensor;   
strain sensor; temperature sensor.

Paper 20200450V received Apr. 20, 2020; accepted for publication Jun. 8, 2020; published online Jun. 25, 2020.

# 1 Introduction

The advent of fiber-optic communication has revolutionized nearly all aspects of communication technology. In the past few decades, optical fiber sensors have been extensively researched and employed for various applications, such as measurement of strain, refractive index, vibration of structures and machines, electric current, voltage, impedance, temperature, pressure, humidity etc. Although there is significant advancement in this field, integration of optical mirrors, partial reflector, and wavelength filters remain a challenge since their integration increases both complexity and cost. However, this problem has been overcome by use of fiber Bragg grating, which alone can perform the basic function of reflection, dispersion, and filtering that can be easily utilized in sensing applications. The process of optical absorption of ultraviolet (UV) light that changes refractive index of the fiber core is called photosensitivity, which forms a fiber Bragg grating (FBG).1

Fiber Bragg grating was first discovered by Ken Hill in 1978 at Communication Research Centre, Canada.2 Ever since its discovery, grating structures have gained wide attention in the area of optical sensing due to their inherent advantages, such as low cost, small size, real-time response, high accuracy, high sensitivity, and immunity to electromagnetic interference. There is great potential of sensing various parameters, such as temperature, pressure, stress, and refractive index using grating-based devices.3 Current applications of fiber Bragg gratings are found in high temperature sensors, health and biomedical devices, structural engineering, industries, biochemical applications, radioactive environment, aerospace, maritime and civil engineering, and many other fields.

In this paper, a detailed study of fiber Bragg grating along with their deployment in various significant applications has been discussed. Mainly, sensing of physical parameters, such as pressure, temperature, strain, liquid level, and also sensing of refractive index, has been discussed.

# 2 Theory of Fiber Bragg Gratings

FBG technology is one of the most admired choices of optical fiber sensors due to their simple manufacturing and relatively strong reflected signal. FBGs are formed by a periodic modulation of the index of refraction of the fiber core along the longitudinal direction.4 They are the devices that are based on the principle of diffraction grating. By grating, it is meant that there is a periodic change in the core’s refractive index. When the light travels inside the grating structure, some portion of light gets reflected back from each grating plane. Figure 1 shows the structure of simple fiber Bragg grating. Every reflected portion of light combines to form one reflected beam of light, but this is possible only if Bragg condition is met. The Bragg condition is given as5

$$
\lambda _ { B } = 2 \Lambda n _ { \mathrm { e f f } } ,
$$

where $\Lambda$ is the grating period that forms the distance between two adjacent grating planes, $n _ { \mathrm { e f f } }$ is the effective core refractive index, and $\lambda _ { B }$ is the Bragg wavelength. When Bragg condition is met, all the reflected light constructively adds up to form backward reflected peak whose central wavelength is given by $\lambda _ { B }$ . The grating structure that follows Bragg condition works as a mirror that reflects selected wavelength $\lambda _ { B }$ and transmits the remaining. If the condition is not satisfied, all the reflections from the grating planes will go out of phase and cancels out, therefore no reflection can be observed. The reflectivity obtained in FBG is estimated by Erdogen’s coupled mode theory6 at each grating inside fiber. The reflectivity $R _ { i } ( \lambda )$ , at each $i ^ { \prime }$ th grating is given as

$$
R _ { i } ( \lambda ) = \frac { \sin h ^ { 2 } \Big ( L _ { g } \sqrt { k ^ { 2 } - \sigma _ { i } ^ { 2 } } \Big ) } { \cos h ^ { 2 } \Big ( L _ { g } \sqrt { k ^ { 2 } - \sigma _ { i } ^ { 2 } } \Big ) - \frac { \sigma _ { i } ^ { 2 } } { k ^ { 2 } } } ,
$$

![](images/6f05350e3d7f1dfa9457bba29b73ceefd7ed9b98e3f6db10b385ef56ce1d9e72.jpg)  
Fig. 1 Structure of fiber Bragg grating along with the transmitted, reflected, and output spectra.

where $\lambda$ is the wavelength, $k$ is the ac coupling coefficient between the two modes, $L _ { g }$ is the length of grating, product of $k$ , and $L _ { g }$ gives strength of grating and for higher $\mathrm { K L } _ { g }$ (for instance 8) value the bandwidth of reflection spectra increases, and it is a unitless quantity. $\sigma _ { i }$ is the dc self-coupling coefficient that gives the dependence of wavelength for every grating and is given as

$$
\displaystyle \sigma _ { i } = \delta + \sigma - \frac { 1 } { 2 } \frac { d \phi } { d z } ,
$$

where $\sigma$ is the dc (period averaged) coupling coefficient, $\textstyle { \frac { d \phi } { d z } }$ is the change in grating chirp, and $\delta$ is given as

$$
\delta = 2 \pi n _ { \mathrm { e f f } } \left( \frac { 1 } { \lambda } - \frac { 1 } { \lambda _ { D } } \right) ,
$$

where $\lambda _ { D }$ is the design wavelength for very weak gratings. When coupled mode theory is applied on reflectivity equation, Eq. (5) is obtained where $\delta n _ { \mathrm { e f f } }$ gives magnitude of refractive index modulation:

$$
\sigma _ { i } ( \lambda ) = \frac { \pi } { \lambda } \delta n _ { \mathrm { e f f } } + 2 \pi n _ { \mathrm { e f f } } \left( \frac { 1 } { \lambda } - \frac { 1 } { \lambda _ { B , i } } \right) .
$$

Grating inside the fiber is formed using various methods. This process of forming gratings in the fiber core is also known as writing inside fiber. Broadly, there are two ways of writing, i.e., internal writing and external writing. Internal writing was first demonstrated by Hill using an argon ion laser and exposing the photosensitive fiber by coupling light in fiber core as shown in Fig. 2. 7 The change in refractive index observed is very small therefore this type of writing is not useful and thus seldom used. Externally inscribed writing is the most commonly used writing and can be performed with various ways, such as interferometer, phase mask technology, pointby-point technique, and line-by-line technique.

In interferometer technology as shown in Fig. 3, 7 light from a laser is utilized and divided into two separate beams using either a prism or beam splitter. Two mirrors are used for the two beams that were separated for reflecting them onto the fiber. Writing operation is performed as the interference pattern is created on the fiber. The period of the interference pattern is dependent on the wavelength of light and also the half angle between the beams that are interfering. The main drawback of this method is that it is difficult to maintain the alignment of the laser beam to obtain better coherency.

![](images/7e0203a60c6c334c452064286399a593f2f801428a173b04a9b674be09962e6c.jpg)  
Fig. 2 Setup of internal inscription method.

![](images/1051b0b7b3632d91f44ca3dd169255029a970c6c54243e9295e6f0ea126b2d23.jpg)  
Fig. 3 Setup of interferometric method.

To overcome the drawback of interferometer technique, phase mask technology can be used. In phase mask technology as shown in Fig. 4, 7 a laser is used as a source to the phase mask layer, which is made using holographic technology or electron beam lithography. The beam from the phase mask gets diffracted into several other beams. The interference pattern is formed on the fiber lying in close proximity to the phase mask layer. Including phase mask technology, femtosecond pulsed laser technique is also considered in new inscription technologies. UV radiation of 228 to $2 5 3 \mathrm { n m }$ spectral region is considered to be most effective in inducing change in refractive index of fiber, therefore a Krypton fluoride (KrF) excimer laser of $2 4 8 ~ \mathrm { n m }$ wavelength is used as a light source in phase mask technique for writing.8 Since there is an issue of change in wavelength of the laser in the case of phase mask technique, femtosecond pulse lasers are normally preferred.

Femtosecond pulsed laser technique provides fully customized grating. It involves formation of precise gratings using an ultrafast laser having time period in femtosecond. This method does not depend on doping material present in the core and no hydrogen loading is required. This technique uses different approaches to form gratings and can be achieved by the interferometric method, phase mask, point-by-point, line-by-line, and plane-by-plane inscription. In the case of point-by-point inscription as shown in Fig. 5, 9 a laser is precisely focused on the fiber core and, at that particular point, the refractive index is modified. To form grating, a mechanically controlled translation stage is involved that repeats the same process every time. This technique

![](images/03290952c6a74856f78a396da22b85d5fd0ec5e0b0c40102da15ecd5fc826d53.jpg)  
Fig. 4 Setup of phase mask technology.

Sahota, Gupta and Dhawan: Fiber Bragg grating sensors for monitoring of physical parameters. . .

![](images/c9fc2d0078b19cce274bd4646070fc14876eac1e857b5a0c27d13803b31ed90d.jpg)  
Fig. 5 Setup of point-by-point femtosecond laser inscription.

involves some insertion loss and also the response is polarization dependent. To resolve the issue of point-by-point inscription, line-by-line inscription is used that provides coarse alignment and has less insertion losses as well as less dependency on polarization.10 The design and performance of the sensor improve drastically depending on the type of inscription. In order to control grating parameters, such as the grating pitch (period), grating length, grating width, and tilt angle, plane-by-plane inscription method can be adopted by simply incorporating a cylindrical lens in the setup.11 This type of inscription is mainly done for complex grating structures. Recently, plane-by-plane technique has been used in cyclic transparent optical polymer (CYTOP) polymer fiber12 and fluoride glass fiber.13 In Ref. 14, gratings were written in fiber coated with acrylate, polyimide, or silicon using a phase mask and femtosecond laser and analyzing their strain responses particularly for high strain resistant applications.

Other than UV or femtosecond laser exposure for fabrication of gratings, $\mathrm { C O } _ { 2 }$ (carbon dioxide) laser irradiation is also used, which is a flexible and inexpensive fabrication process. This is because no pretreatment such as photosensitization of fiber is required in this process and also no expensive phase-masks are required.15 $\mathrm { C O } _ { 2 }$ lasers are driven by computer-controlled translation stage and radiated periodically along the axis of fiber. Complicated gratings can be formed as in the femtosecond laser method using point-by-point approach. $\mathrm { C O } _ { 2 }$ lasers can be used to inscribe gratings such as long period gratings in silica fiber,16 in photonic crystal fiber $( \mathrm { P C F } ) ^ { 1 7 }$ and even in air-core photonic band gap fiber18 and superstructure gratings.19 But a $\mathrm { C O } _ { 2 }$ laser is not suitable for pure fused silica PCFs since they are fragile and can easily damage its holey structure. 20

Broadly, optical sensors can be either point-based sensors or distributed-based sensors.21 In distributed sensors, the mechanism of sensing is performed continuously along the fiber, which therefore allows continuous sensing of measurand. Distributed type of sensing is one where spatial distribution of measurand is measured by time-domain reflectometry.22 Rayleigh scattering, Raman scattering, and Brillouin scattering work as distributed-based optical sensors, but they are seldom used due to high cost. In the case of point-based sensors, sensing mechanism is performed at a discrete point of the fiber. Point-based optical sensors are those sensors where sensing is achieved at particular point of fiber and can be either interferometer-based or fiber grating-based. In interferometer-based sensors, an interference pattern is formed that holds the information of sensing. Mach–Zehnder interferometer, Michelson interferometer, Sagnac interferometer, and Fabry–Perot interferometer (FPI) are example of point-based sensor. Fiber Bragg gratings also fall in the category of point-based sensor as sensing is performed only at small grating part. A point-based sensor has the ability of multiplexing, which can be used in distributed sensing of external perturbations. Depending on the gratings formed, fiber Bragg gratings can be uniform FBG,3 chirped FBG,23,24 tilted FBG,25,26 long grating fiber,27 29 phase-shifted FBG,30,31 or super-structured FBG.19 These gratings are usually inscribed in silica-based fiber but many research studies have been carried out on inscribing FBG in microstructured optical fiber (MOF) forming a microstructure $\mathrm { F B G } ^ { 3 2 , 3 3 }$ or polymer-based $\mathrm { F B G } ^ { 3 4 }$ that can offer unique

Sahota, Gupta and Dhawan: Fiber Bragg grating sensors for monitoring of physical parameters. . .

![](images/8c56f310bcf924fded34952e054451bb2074aacd07a516233a25b9cc3ac2b253.jpg)  
Fig. 6 Various types of gratings.

capability in enhancing sensing applications. Figure 6 differentiates various types of gratings in optical fiber that can be used in sensing application.

Depending on the growth mechanism that includes specific inscription condition, specific laser type, type of optical fiber, and photosensitivity condition there are four types of fiber Bragg gratings, i.e., typeI, type IA, type II, and type IIA.7 Type I fiber grating or standard gratings is the most widely used type of FBG and is made using common photosensitive fiber using moderate intensity. The gratings are written either with or without hydrogen loading in the fiber. For high reflectivity, FBG should exhibit high photosensitivity, which can be achieved by either doping the silica fiber with photosensitive material such as germanium or by hydrogen loading with high pressure and at low temperature.35 Also, when hydrogen is loaded in germanium doped FBG, photoinduced index increases to 10 times to that of unloaded FBG.36 This type of fiber is used relatively at low range of temperature $\mathrm { - 4 0 ^ { \circ } C }$ to $8 0 ^ { \circ } \mathrm { C }$ ). Since there is negligible absorption and scattering loss, the transmission spectra is almost opposite to reflection spectra of type 1 FBG. Type IA gratings are formed after removal of standard gratings using intense exposure of UV in hydrogenated germanosilicate (germanium doped silica) fiber. Such gratings show large redshift in Bragg wavelength due to large change in refractive index of core, which is almost six times larger than conventional gratings. This type of gratings can be very well used for temperature compensated sensors as they exhibit low temperature coefficient.37 Type II fibers are made by exposing the standard gratings under UV radiations for a longer duration using hydrogenated germanosilicate fiber. During its inscription process, a large red wavelength shift is observable at Bragg wavelength. The mechanism of formation of such type of grating is based on multiphoton excitation using high intensity laser that will surpass the damage threshold of glass fiber in order to induce high index change in core. Such fiber has a working range at around $8 0 \mathrm { { } ^ { \circ } C }$ temperature.

Type II gratings are developed using high radiation exposure $( 0 . 5 \ \mathrm { J / c m \ s q } )$ of UV radiations focused at core-cladding interface causing large refractive index modulation. They are characterized by the damage at core-cladding boundary. They pass wavelengths greater than Bragg wavelength. Since they operate at high temperature $( \approx 3 0 0 ^ { \circ } \mathrm { C } )$ therefore they can be effectively used for several sensing applications. Type IIA fiber gratings are similar to typeIA gratings in terms of inscription process, but the only difference is that type IA is inscribed with hydrogen loading and type IIA is inscribed without hydrogen loading. They are inscribed through a long process following inscription process of typeI. It needs UV exposure of around $3 0 \mathrm { { m i n } }$ to be fully developed. In Ref. 38, type I gratings and type II gratings were formed using IR-laser and phase mask technique. All types of fiber discussed above have similar strain sensitivity but different temperature sensitivity, which is mainly lower for hydrogenated fiber and higher for nonhydrogenated fiber.39

# 3 Sensing Mechanism of FBG

FBG sensor works on the principle of wavelength shift. According to coupled mode theory,40 Bragg wavelength depends on the physical parameters of fiber which are grating period and effective refractive index. Shift in the wavelength of reflected spectrum either to the left or right of central wavelength is caused only if either the period of gratings or effective refractive index of FBG is changed by parameter to be measured, such as temperature, strain, humidity, pressure, etc. According to Bragg condition, wavelength change can be found, which is indicative of the amount of external perturbation applied on FBG as shown in Fig. 7.

![](images/6754e23687751c0b6c6ba68a18e79e45a652fa0ebca639fafc10f5879171428d.jpg)  
Fig. 7 Wavelength shift due to external perturbation.

To understand how the sensing mechanism of FBG takes place, consider an external parameter $X ^ { \dag }$ also called the measurand quantity, which may be temperature, strain, pressure, or refractive index. The Bragg wavelength of FBG is dependent on this external parameter and can be calculated by differentiating Eq. (1) with the measurand parameter “X” as4 1

$$
\frac { d \lambda _ { B } } { d X } = 2 \frac { d \big ( \Lambda n _ { \mathrm { e f f } } \big ) } { d X } = 2 \Lambda \frac { d n _ { \mathrm { e f f } } } { d X } + 2 n _ { \mathrm { e f f } } \frac { d \Lambda } { d X } .
$$

Since Bragg wavelength is dependent on grating period and effective refractive index of FBG, the measurand parameter will change either effective refractive index or grating period of FBG or both depending on the type measurand.

# 4 Interrogation of FBG Sensor

The key challenge in FBG sensing is the interrogation of the parameter signal encoded in the wavelength shift. The sensing principle of FBG sensors involves detection of central wavelength variation. Most conventional interrogation method utilizes an optical spectrum analyzer (OSA) with broadband source as it performs direct measurement of the reflection spectrum of the FBG. Figure 8 shows interrogation of FBG using OSA. However, OSA provides low resolution and slow response speed that cannot satisfy the requirements of accurately detecting the small and dynamic variations of the FBG’s central wavelength. It can be used only for laboratory test purposes. Therefore, for real sensors, it is of significance to have interrogators that can work at high scanning speed to achieve dynamic sensing. Mainly interrogators can be either passive or active. Passive interrogation does not involve active electrical, mechanical, or optical devices. It involves interrogators having passive devices such as filters that are wavelength dependent such as edge filters42–45 or wavelength division multiplexing (WDM).46 Power detection-based passive interrogation is another method, where source having intensity that is wavelength dependent such as erbium-doped amplifier fiber is used. Chirped FBG was also used in Ref. 47 to measure dynamic strain using EDFA source. For interrogation of multiple FBG, charged couple device spectrometer48 as a passive device can be used where multiple wavelengths reflected illuminating different area of pixels.

Active interrogation method involves comparatively more complex system than passive interrogators but gives better resolution. Many researchers have worked on various active interrogation methods such as using Fourier-domain mode locked laser fiber,49 optical frequency comb,50 Fabry–Perot filter,51 and acousto-optic tunable filter.52

# 5 Multiplexing in FBG Sensors

In several applications, multiple sensors or array of sensors are required to carry out measurements of either the same parameter at multiple places or multiple parameters located at different places of the structure. The sensors can be either surface mounted or embedded in smart structures. For instance, monitoring of railway track with FBG sensor would comprise multiple FBG sensors laid over track of railway line. Therefore, several multiplexing techniques are required to achieve distributed sensing network. Many multiplexing techniques have been reported in studies such as time division multiplexing (TDM), spatial division multiplexing (SDM), WDM, frequency modulated continuous wave (FMCW), and many hybrid multiplexing methods.

![](images/b61c1cddbb7fb785a67a86b42a85e0868f9cd7a10c2b6aa9ebd15abdbd601797.jpg)  
Fig. 8 Interrogation of FBG using OSA.

The most commonly used multiplexing technique is TDM and WDM in FBG sensing. In WDM method, every FBG is encoded with a different wavelength from every other FBG. The array of FBG is illuminated by a broadband light signal having a spectral width covering all the wavelengths encoded to several FBG. The reflected light from array of FBG is interrogated with a wavelength detection scheme. This method is usually preferred when FBG’s are spaced at different locations with unequal distance. Fabry Perot tunable filter can be used to distinguish among various wavelengths by operating it in scanning mode.53 Other methods such as band-pass wavelength division demultiplexer,54 Mach–Zehnder interferometer, and FBG laser sensing system55 can also be used to interrogate different wavelengths. When an array of FBG is arranged in such a manner that distance remains the same between adjacent FBG, then mostly TDM technique is preferred. In TDM method of multiplexing, the return pulses from the FBG are recovered with two pulses separated by a distance that is equal to the round trip time between gratings.56 Phasesensitive detection schemes such as Mach–Zehnder interferometer can be used to interrogate reflected pulses from FBG.57 In Ref. 58, switched semiconductor optical amplifier-based TDM scheme was used to interrogate FBG. TDM can reuse the wavelength spectrum of light source and can multiply the number of FBG’s operating in a single fiber, which in the WDM case can only be around 10 FBG. Hybrid TDM-WDM technique offers usage of a large number of FBG sensors and also provides higher reflectivity, which in the case of TDM and WDM is low. Simultaneously using TDM and WDM is carried out in Refs. 59 and 60 for high power signal. SDM method is used when several FBGs have similar characteristics, operated independently in the network, and have the ability to interchange.61 Unlike distributed measurements in WDM or TDM, SDM performs point measurements. Michelson interferometer was used for scanning wavelength in SDM-FBG sensor system to measure quasistatic strain and temperature by multiplexing 32 FBG.62 To further enhance the multiplexing capability, SDM can be used along with TDM or WDM methods. In Ref. 63, hybrid SDM-WDM method was used to multiplex 20 FBG in four channels for use in detecting shape of endoscope FMCW method of multiplexing also known as optical frequency-domain reflector provides high spatial resolution with large capacity by employing source having narrow line-width and fast acquisition setup.64 In Ref. 65, hybrid FMCW-WDM method was used where the source was modulated by linearly swept radio frequency carrier signal and reflected signal from 8 FBGs were demodulated using optical tunable filters.

# 6 Progress in FBG Sensor Design

# 6.1 FBG-Based Refractive Index Sensor

Measurement of refractive index is of prime concern when dealing with quality check of certain material used in different industries, such as biological, chemical, medicine, and pharmaceutical. Various methods of chemical sensing using distributed sensor such as Rayleigh scattering and Raman scattering phenomenon have been already reviewed in Ref. 66. Also, recent developments made in the area of FBG-based biosensing with nanocoatings to measure refractive index have been reviewed in Ref. 67. According to Bragg’s condition, the Bragg wavelength is directly dependent on effective refractive index $( n _ { \mathrm { e f f } } )$ of FBG core. Therefore, change in $n _ { \mathrm { e f f } }$ induces change in Bragg wavelength, which can be expressed as

$$
\Delta \lambda = 2 \Delta n _ { \mathrm { e f f } } \Lambda .
$$

Refractive index sensing using a normal uniform fiber Bragg grating is difficult since effective refractive index of FBG is not affected easily by external perturbation. Therefore, they are not much sensitive to external refractive index. Additional efforts are required to make FBG sensitive to external refractive index. For this reason, the cladding portion of FBG is sometimes etched partially or completely. Sensing of refractive index can be achieved using etched FBG, no-core fiber, tilted FBG, thinned cladding fiber, or long period grating fiber, which basically modifies the structural design of sensor. It was theoretically as well as experimentally studied in Ref. 68, that as the thickness of cladding was reduced by submerging in HF (hydrofluoric acid) solution the effective refractive index was increased exponentially. High sensitivity for etchedshown significant role in sensing application of refractive index, temperature, humidity, and curvature. Interaction of evanescent wave with external parameter increases sensitivity, which can be obtained using no-core fiber. In Ref. 69, no-core fiber-based long period grating sensor for sensing refractive index with compensated temperature was designed. No-core fiber of $1 2 5 \ \mu \mathrm { m }$ diameter is made of pure quartz with no core present in it and inscribed with long period gratings. The refractive index of no-core fiber lies between the refractive index of core and cladding of normal fiber. No-core fiber is sandwiched between single-mode fiber after every period of grating. Most of the light traveling is present at the end of the fiber in cladding. Such a structure causes a constant exchange of energy between cladding and core thereby causing change in refractive index and higher order cladding modes are motivated. In the proposed structure, isotropic coupling is experienced. Both refractive index and temperature sensitivities were investigated using this structure. The wavelength sensitivity obtained was $1 4 1 . 8 3 7 ~ \mathrm { n m }$ ∕refractive index unit (RIU) with 1.33 to 1.40 RIU range. Temperature sensitivity calculated was low at $- 6 . 4 3 ~ \mathrm { p m } / ^ { \circ } \mathrm { C }$ and $0 . 0 0 5 ~ \mathrm { d B } / { } ^ { \circ } \mathrm { C }$ . It was also observed from the temperature sensitivity that the proposed sensor is more robust than the conventional long period grating. Similar study on LPGbased refractive index sensor was conducted in Ref. 70, using thinned cladding long period grating fiber. In thinned cladding fiber, the core and cladding diameters are relatively smaller than the diameters of that of conventional single-mode fiber. In the proposed structure, the thinned cladding fiber was embedded in the single-mode fiber thereby forming an in-fiber Mach Zehnder interferometer due to mode field mismatch of single-mode fiber and thinned cladding fiber. The long period gratings were inscribed on the thinned cladding fiber using $\mathrm { C O } _ { 2 }$ (carbon dioxide) laser. At the splice junction of thinned cladding and single–mode fiber, cladding modes are excited as they are sensitive to the surrounding change in refractive index. A high wavelength sensitivity of $7 3 6 6 . 6 ~ \mathrm { n m / R I U }$ was achieved, which was higher than conventionally inscribed long period gratings in single-mode fiber. The bending sensitivity and temperature sensitivity obtained were $2 . 3 2 ~ \mathrm { d B / m ^ { - 1 } }$ and $7 0 . 8 5 ~ \mathrm { p m } / ^ { \circ } \mathrm { C }$ , respectively. The study was conducted experimentally and theoretically and results were well consistent. Though long period gratings provides higher sensitivity than etched fiber Bragg gratings but limits accurate measurement because of large transmission. Addressing to this problem, a new technique71 involving the concept of microwave photonics for measuring refractive index with high resolution using phase-shifted FBG and optoelectronic oscillator was introduced. Phase shifted FBG (PS-FBG) has a spectral width of reflection spectra of around $1 1 \mathrm { p m }$ , which is almost 10 times smaller than that of uniform FBG having a spectral width of $1 0 0 \ \mathrm { p m }$ .72 This is one feature that improves accuracy but the main reason for high resolution is the microwave photonic filter whose central frequency is function of Bragg wavelength of PS-FBG. The change induced in Bragg wavelength of PS-FBG by external refractive index variation is then directly measured by oscillating frequency change. The change in frequency can be easily interrogated by digital signal processor with high resolution. But high resolution comes at cost of expensive electrical spectrum analyzer. Another prominent technology, i.e., tilted fiber Bragg gratings (TFBG), has been nowadays widely used for measuring surrounding refractive index for submicroliter samples.26 The downside of using TFBG is high loss in propagation of cladding modes, which was overcome by a technique used in Ref. 73, where the refractometer working on the phenomenon of recoupling of cladding and core was proposed and experimentally demonstrated. The sensor consisted of TFBG tilted at an angle of 12 deg and gratings inscribed with phase masking technique using a KrF excimer laser in hydrogen $( \mathrm { H } _ { 2 } )$ ) loaded single-mode fiber. The cladding of fiber was coated with $3 \mathrm { - } \mu \mathrm { m }$ thick gold to reflect light in cladding and guide it in the core. With gold coating, infiber cladding mirror was formed, which backreflects the light to core and TFBG effectively couples the forward core modes and backreflected cladding modes thereby recoupling them into the same tilted grating fiber. Transmitted modes were monitored in the form of reflected light. The proposed design of the refractometer is considered to have larger range of operation as compared to the other tilted grating fiber-based refractometer with linear sensitivity of $5 2 8 ~ \mathrm { n m / R I U }$ . The cross-sensitivity effect of temperature was under control in this design since core mode is not sensitive to surrounding refractive index. The wavelength sensitivity was improved to 7973 dB∕RIU using tunable laser. Some more studies on FBG-based refractive index sensor along with their inferences are discussed in Table 1.

Table 1 Various FBG-based techniques for refractive index sensing.   

<html><body><table><tr><td>Reference</td><td>Technique</td><td>Inferences</td></tr><tr><td>69</td><td>Long period grating embedded in no- core fiber</td><td>Averagewavelengthsensitivityachievedwas 141.837 nm/RIU in the range of 1.33 to 1.4 RIU.</td></tr><tr><td>70</td><td>Long period grating written in thinned cladding fiber</td><td>Refractive index sensitivity of 6812.0 and 7366.6 nm/RIU was obtained for LPG written thinned cladding for κL&lt;π/2 and xL&gt;π/2, respectively.</td></tr><tr><td>176</td><td>Etched fiber Bragg grating in Panda fiber</td><td>Refractive index sensitivity of -1.492 nm/RIU was obtained for resolution of 0.06 nm.</td></tr><tr><td>71</td><td>Optoelectronic_oscillator with etched phase-shifted FBG</td><td>An index variation of 1.9 ×10-6 RIU with sensitivity of 530 MHz/RIU was obtained.</td></tr><tr><td>68</td><td>Etched fiber Bragg grating</td><td>Wavelength shifted to higher values when proposed sensor was submerged in water,but mode power leaks in case of submersion in oil.</td></tr><tr><td>73</td><td>Tilted FBG with gold coating</td><td>Sensitivity of 7973 dB/RIU was obtained with limit of 10-6 RIU.</td></tr><tr><td>177</td><td>Single-mode-multimode-single-mode fiber (SMF-MMF-SMF) structure</td><td>Sensitivity of 7.33 nm/RIU obtained for range 1.324 to 1.439 refractive index.</td></tr><tr><td>178</td><td>Exposed core microstructured optical fiber</td><td>Refractive index sensitivity of 5.85 nm/RIU was achieved.</td></tr><tr><td>179</td><td>D-shaped fiber with long period grating</td><td>Extremely high refractive index of 9786%/RIU achieved for range 1.4 to 1.45 refractive index.</td></tr><tr><td>120</td><td>Micro-sapphire-FBG</td><td>Refractive index measurement in range of 1 to 1.75 was obtained with fiber operating at 1400C temperature.</td></tr></table></body></html>

# 6.2 FBG-Based Strain Sensors

In this section, FBG-based strain sensors used in various applications are discussed though an extensive review on interrogation methods for FBG strain sensor has been carried out in Refs. 74 and 75. Strain sensing is utilized in almost every type of industry and the most conventional method used is strain gauge technology for testing automobiles, infrastructures, etc. Due to inherent advantages of FBG, it has taken over conventional methods though FBG cannot completely compete with strain gauges regarding price. But due to mentioned properties of FBG, they find a place in special applications involving modern constructions such as airplanes or wind power plant since they match quite well with composite materials employed in such areas. Fiber Bragg gratings for strain sensing play a very crucial role in almost every area of application, such as condition monitoring, structural health monitoring (SHM), and fault diagnosis. Stress applied on FBG induces change in either effective refractive index or grating pitch of FBG, which causes a change in wavelength shift. Strain sensitivity of FBG depends on physical characteristics of fiber such as thermo-optic coefficient and elasto-optic property and also on the type of strain (tensile or compressive) applied on it.2 Bragg gratings are made on silica fiber whose strain limit is around 4.8G Pa.76 To increase the strain limit of FBG, it can be coated with some suitable material. By coating FBG with some different material using adhesive, the strain transferred from the outside of FBG to the inside of core may vary depending on physical properties of adhesive used. Some amount of strain may get absorbed by the intermediate layer such as glue, which may result in inaccurate results and must be taken care of. In Eq. (6), if measurand $X$ is replaced by strain, $\varepsilon$ , then it can be transformed to

$$
\Delta \lambda _ { B } = \lambda _ { B } \big ( 1 - \rho _ { a } \big ) \varepsilon ,
$$

where $\rho _ { a }$ is the stress optic coefficient and is given as

Sahota, Gupta and Dhawan: Fiber Bragg grating sensors for monitoring of physical parameters. . .

$$
\rho _ { a } = \frac { n _ { \mathrm { e f f } } ^ { 2 } } { 2 } [ \rho _ { 1 2 } - \sigma ( \rho _ { 1 1 } - \rho _ { 1 2 } ) ] ,
$$

where $\sigma$ is the poisson’s ratio and $\rho _ { 1 1 } , \rho _ { 1 2 }$ are pockel’s coefficient or coefficient of stress-optic tensor. For isotropic strain, change in Bragg wavelength with change in strain can be written as

$$
\Delta \lambda _ { B } = \lambda _ { B } \big ( 1 - P _ { e } \big ) \varepsilon ,
$$

where $P _ { e }$ is the strain-optic coefficient whose value for germanium doped silica fiber is 0.22, from which Eq. (11) can be formed:

$$
\Delta \lambda _ { B } = 0 . 7 8 \varepsilon \lambda _ { B } .
$$

Strain gauge method for strain measurement is the most commonly used method where change in resistance due to induced strain is determined by Wheatstone bridge circuit. Since it is not electrically isolated, therefore it cannot be used in many such applications where electrical isolation is necessary. An experiment was performed between FBG and strain gauge in Ref. 77, where FBG-based strain sensing showed more accurate results as compared to strain gauge method. Two FBG and strain gauge were pasted on one side of equi-intensity cantilever beam, and on other side different weights were added that were to be tested. The strain value obtained from FBG was found much closer to the theoretically calculated strain as compared to strain gauge. Many more studies based on a cantilever where FBG is usually pasted for strain calculations have been performed in the past. In Ref. 78, embedded stress distribution of FBG was analyzed using cantilever structure where FBG sensor was pasted along the length of cantilever. The curvature or displacement is measured using FBG sensor produced by lateral load on the cantilever structure. Using method of mechanics of materials, stress relation with parameters of FBG is obtained and the reflection spectrum of FBG is achieved using transmission matrix method, which is suitable for measuring linear or uniform strain.79 Another study using a cantilever beam for FBG using collimators to measure strain was proposed in Ref. 80, where FBG sensor was installed on cantilever beam. The sensor was demodulated using FBG interrogator connected via a pair of collimator. The collimator helps in maintaining the alignment of light between the FBG sensor and interrogator. The results showed accurate strain measurements with collimators. Another cantilever structure was utilized in Ref. 81 where a sensitizing structure was designed using flexure hinge and FBG was passed through that structure and further pasted on the cantilever with epoxy. With this design, sensitivity was improved by 10 times, which can be used for monitoring dynamic strain on mechanical structures accurately.

Strain sensing at high temperature can be a big challenge for FBG as silica material operates at a low temperature range. Nowadays, polymer-based optical fibers are extensively being used in sensing technology due to their high fracture limit and biocompatibility. In Ref. 82, polyimide was utilized in Fabry–Perot-based strain sensor, which was able to endure strain of $3 5 \%$ even at a temperature of $2 2 0 ^ { \circ } \mathrm { C }$ . FBG can also be effectively used for strain sensing at high temperatures using suitable polymer coating materials such as metals having high thermal expansion coefficient or also using polymethylmethacrylate (PMMA)-based FBG.34,83 Silica-based FBG is capable of operating at a temperature ranging from $- 6 0 \mathrm { { } ^ { \circ } C }$ to $8 0 \mathrm { { } ^ { \circ } C }$ having acrylate coating whereas with Pyrocoat coating operating temperature can range up to $3 0 0 ^ { \circ } \mathrm { C }$ but fiber must not be exposed at high temperature for a longer duration of time.84 PMMA-based fiber has glass transition temperature of about $1 6 5 \mathrm { ^ \circ C }$ , and above this temperature the physical properties of polymer changes. Strain sensor based on FBG-PMMA was proposed in Ref. 83, where fiber Bragg gratings were inscribed in microstructured polymer optical fiber (mPOF) made up of a special polymer called PMMA using phase mask technology. In this study, PMMA-based fiber was used to sense strain for longer duration since PMMA has very low Young’s modulus (low stiffness) thereby increasing the limit of elasticity. Depending on the magnitude and time of strain applied on polymer fiber visco-elasticity could be calculated. In the experiment, different amounts of strains, i.e., $0 . 4 \%$ , $0 . 6 5 \%$ , and $0 . 9 \%$ , were applied on the polymer for different duration of time, i.e., 2.5, 5, 10, and $5 0 \mathrm { { m i n } }$ and fiber was left relaxed for $^ { 2 \mathrm { h } }$ . It was observed that for $65 \%$ and above of the strain range the fast relaxation range is desired. The calculated results are valid only for unembedded polymer fiber, and if embedded fiber is used the results will directly depend on the material properties of host. It was also confirmed from the experiment performed that even after prestraining the fiber the following strain applied could be effectively calculated in real-time therefore prestraining was not an issue in this case. Recently, polymer such as PMMA,85 cyclic-olefin copolymer (TOPAS86,87 and Zeonex88), polycarbonate89-based FBG has taken over conventional silica-based FBG because of its distinctive material properties such as low Young’s modulus and high fracture toughness that can be effectively used in enhancing strain performance of sensor. Inscription of gratings in such polymers can be made using 248-nm KrF laser90 for stable grating, and ultrafast gratings in 7 ms were formed on PMMA using dopant (diphenyl disulphide) as discussed in Ref. 91. Table 2 shows comparison of a few polymer-based FBGs for strain sensing.

FBGs can be deployed in many safety monitoring engineering or civil structures for their SHM. In Ref. 92, structural deformation of Chinese ancient timber building was monitored using FBG-based sensor system. Physical parameters, such as temperature, fire, humidity, and inclination, were monitored within 15 months to validate the long-term process of SHM system. It was observed that the foot column of timber was under stress and was prone to cracking in 20 years of service. Also, an FBG sensor was used in health monitoring of airship ZHIYUAN-1 nose-cone93 where three FBGs were pasted on the nose-cone. The strain was interrogated with a commercial interrogation system (Micron Optic sm-130), which is the main part of the whole sensing system as it provides a resolution of $1 \mathrm { p m }$ . To validate the experiment, qualitative strain monitoring of the airship was made. Also, to confirm the results of the experiment, finite element analysis was carried out. FBG can be used for strain monitoring of gas combustion. In Ref. 94, an experimental study was conducted on the flammable explosion of ethylene for monitoring strain in the process of detonation, deflagration, and discharge. Packaged FBG using 502 adhesive was pasted on inner surface of steel testing device where ethylene gas was released using an ethylene gas cylinder. In the experiment, FBG successfully monitored the strain values at $0 . 5 \ \mathrm { M P a }$ . Similarly, FBG was used for measuring dynamic strain from the explosion on blast doors, which is very helpful from a safety point of view usually employed in tunnels or subways.9 In the experiment, eight FBGs were pasted horizontally and vertically on the blast door (reinforced concrete material), and strain data were successfully measured in explosion test. The role of FBG in structural monitoring is used in many studies, and their main purpose in some applications is to have early warning as discussed in Ref. 96, where strain was monitored for expressway slopes. Prewarning of land sliding from slopes surrounding the road can be made using an FBG sensor can measure the horizontal displacement of soil and the axial strain distribution of soil nails, which is used to stabilize soil. The strain and displacement obtained in the experiment were $1 9 8 \ \mu \varepsilon$ and $5 . 0 6 \ \mathrm { m m }$ , respectively. SHM of concrete structure was discussed in Ref. 97, using polystyrene foam covered FBG. The expansion of corrosion induces formation of cracks in a concrete structure, which degrades the durability of concrete. The material covering FBG used was polystyrene, which is a lightweight and good energy absorber that will provide good protection to FBG.

Apart from designing aspect of the FBG strain sensor for sensitivity enhancement as discussed in Refs. 81, 98, and 99, type of interrogation plays an important role in overall evaluation of sensor performance. Especially in cases where dynamic or quasistatic strain monitoring is involved, an interrogation scheme different from static sensing is applied. For static strain sensing, mostly broadband source and optical analyzer are utilized in demodulating the signal. This method cannot be applied on dynamic strain sensing because of slow measurements on the optical analyzer, low signal-to-noise ratio, and low resolution. Such systems comprise of broadband source to cover the bandwidth of measurand and are usually referred as passive FBG sensor system. The power of the reflected signal is generally low in passive FBG sensor system thereby causing low accuracy in sensing measurements and also a smaller number of FBG can be multiplexed in such system. To resolve this issue, research has been carried out in FBG laser sensor system that is able to provide high output power with narrow line-width. In Ref. 100, fiber laser strain sensor was proposed based on a distributed Bragg reflector (DBR) laser, which was formed by two FBG inscribed in erbium doped fiber (EDF). The two gratings form a Fabry Perot cavity whose length determines the wavelength and when strain is applied on such structure the cavity length changes. The wavelength change is demodulated by Mach–Zehnder interferometric method that converts wavelength to intensity. In this study, sensitivity of $8 0 ~ p \varepsilon / \sqrt \mathrm { H z }$ was obtained for frequency range $1 0 0 ~ \mathrm { { m H z } }$ to several hundred hertz. In Ref. 101, DBR fiber laser-based simultaneous strain and temperature sensor was proposed for high resolution and was achieved by measuring the laser wavelength and polarization beat frequency. Similarly, for simultaneous sensing of strain and axial load, a DBR fiber laser sensor can be used.102 Many interrogation schemes for dynamic or quasistatic strain sensing have been reported achieving high-resolution. Methods such as interferometric methods, scanning filters, edge detection filter, wavelength-swept laser, and many more such dynamic strain interrogation techniques have been presented in past research and are also listed in Table 3.

Table 2 Polymer-based FBG for strain sensing.   

<html><body><table><tr><td>Reference</td><td>Material</td><td>Result</td><td>Strain</td></tr><tr><td>88</td><td>Zeonex</td><td>Strain sensitivity of 39.791 ± 0.004 pm/με is attained.</td><td>0.3%</td></tr><tr><td>89</td><td>Polycarbonate</td><td>Strain sensing up to 3% with a linear response of the grating to temperature up to 125 C.</td><td>3%</td></tr><tr><td>24</td><td>PMMA</td><td>Strain sensitivity of 0.90 pm/με is obtained.</td><td>2%</td></tr><tr><td>180</td><td>TOPAS</td><td>High strain operation (2.5%) of the FBG at 98 C and stable operationup toa high temperature of 110℃.</td><td>2.5%</td></tr></table></body></html>

Simultaneous sensing of temperature and strain causes low sensitivity and inaccurate results. Simultaneous measurement of strain and temperature was discussed in Ref. 103, where a simple optical sensor has been designed using fiber Bragg gratings and long period gratings. Many sensing heads have been incorporated in the proposed sensor design where each sensing head will include both the long period gratings and fiber Bragg gratings thereby forming a concatenation. By measuring the reflected power and wavelength of fiber Bragg gratings both strain and temperature responses could be obtained. Many more studies have been conducted in the past for simultaneous measurement of temperature and strain with FBG.104–107 Table 4 compares various FBG strain sensors.

Table 3 Interrogation methods of FBG strain sensor.   

<html><body><table><tr><td>Reference</td><td>Interrogation technique</td><td>Inferences</td><td>Perturbation type</td></tr><tr><td>181</td><td>VCSEL array swept source</td><td>Sweeps bandwidth of 10 nm at a scanning rate of 4 kHz</td><td>Dynamic</td></tr><tr><td>50</td><td>Electro-optical dual optical frequency combs</td><td>Measured dynamic strain vibrations (200 Hz and 1 kHz, 18 and 56 με, respectively) and ultrasounds (40 and 120 kHz,0.4 and 0.32 με,respectively)</td><td>Dynamic</td></tr><tr><td>182</td><td>Linearly wavelength-swept thermo-optic laser chip</td><td>Sweeps bandwidth of 11.8 nm with scanning rate of 16 Hz</td><td>Dynamic</td></tr><tr><td>183</td><td>Cascaded long-period fiber grating</td><td>Strain resolution of 1 με obtained</td><td>Dynamic and static</td></tr><tr><td>49</td><td>Fourier-domain mode- locked fiber laser</td><td>The frequency resolution of the dynamic variation could reach up to O.5 Hz for 2 s integration time</td><td>Dynamic</td></tr><tr><td>184</td><td>Interferometric method</td><td>Dynamic resolution of 4 pε/√Hz obtained</td><td>Dynamic</td></tr><tr><td>185</td><td>Optoelectronic oscillator loop</td><td>Sensitivity of 58 Hz/με obtained</td><td>Dynamic</td></tr><tr><td>186</td><td>Low loss jammed-array wideband sawtooth filter</td><td>Interrogation at rate of 20o kHz can be achieved</td><td>Dynamic</td></tr></table></body></html>

Table 4 Various FBG-based techniques for strain sensing.   

<html><body><table><tr><td>Reference</td><td>Technique</td><td>Inferences</td><td>Packaging</td><td>Application</td></tr><tr><td>97</td><td>Polystyrene-coated FBG</td><td>For 0.169% corrosion, the FBG was still intact with the steel reinforcement</td><td>Polystyrene foam covering</td><td>Corrosion monitoring in concrete</td></tr><tr><td>187</td><td>FBG strain gauge</td><td>Large axial strain corresponding to 2.262 Hz frequency was identified</td><td>FBG bonded on steel structure</td><td>Vibration sensing of bridge</td></tr><tr><td>188</td><td>Steel packaged FBG</td><td>Able to take load up to 50 KN</td><td>FBG bonded on steel structure with ultraviolet glue</td><td>Derrick monitoring in oil and gas field</td></tr><tr><td>189</td><td>Eccentric core FBG</td><td>Strain sensitivity of 0.76 pm/με was obtained for eccentric FBG in the range 0 to 1200 με</td><td></td><td>Simultaneous sensing of strain and bend</td></tr><tr><td>190</td><td>FBG strain rosette structure</td><td>Average strain sensitivity coefficient of 0.89 με/pm obtained</td><td>Coating (Young&#x27;s modulus: 3 GPa, Poisson&#x27;s ratio: 0.35)</td><td>SHM of ship hull</td></tr><tr><td>99</td><td>Lever mechanism</td><td>Strain sensitivity of 11.49 pm/με was achieved</td><td>FBG bonded on steel structure casing comprising of flexure hinge, lever,and serpentine spring</td><td>Strain monitoring of lithium ion battery</td></tr><tr><td>191</td><td>Elastic mechanic theory</td><td>Strain sensitivity of 0.59 pm/με was achieved</td><td></td><td>Early warning monitoring of slope</td></tr><tr><td>174</td><td>Phase-shifted FBG with femtosecond laser</td><td>Strain sensitivity of 0.867 pm/με was achieved in the range 0 to 3500 με</td><td></td><td></td></tr><tr><td>83</td><td>PMMA microstructured FBG</td><td>Able to perform strain measurements up to 0.9% for 50min</td><td></td><td>SHM where durability is of prime concern</td></tr><tr><td>192</td><td>FBG-based strain sensor using 3-D printing method</td><td>Resolution and sensitivity ofPVC protective tube 114 μm and 0.0218 nm/mm achieved,respectively</td><td></td><td>Circumferential strain monitoring</td></tr><tr><td>81</td><td>Flexible hinge</td><td>Strain sensitivity of 10.84 pm/με was achieved</td><td>FBG bonded on copper alloy flexible hinge structure</td><td>Health monitoring of mechanical structures</td></tr><tr><td>193</td><td>Fourier curve fitting</td><td>Real-time monitoring of stress achieved with averageepoxy resin adhesive error of stress being 3.9 με</td><td>FBG bonded with on specimen</td><td>Stress hole monitoring in aircraft</td></tr><tr><td>194</td><td>FBG embedded in small core PCF</td><td>Strain sensitivity of 0.67 pm/με achieved</td><td>PCF bonded on beam with heat cured epoxy (EPO TEK 353ND)</td><td></td></tr><tr><td>98</td><td>FBG with lever structure</td><td>Strain sensitivity of 6.2 pm/μεachieved</td><td>Resin protective tube</td><td>Harsh industrial environment</td></tr></table></body></html>

# 6.3 FBG-Based Temperature Sensor

Sensing of temperature is the most common parameter used in almost every area of application. Conventional temperature sensors such as thermostat, thermocouple, and resistance temperature detector are bulky in size, have low range of operation, are not immune to EMI, and are not suitable for distributed sensing. Fiber Bragg gratings-based sensors are highly reliable, have low thermal conduction, are small in size, and are strongly immune to EMI. Thermo-optic effect is the prime cause of temperature sensitivity in FBG.2 Differentiating Eq. (1) by temperature gives relation between change in wavelength and change in temperature as1

$$
\frac { \Delta \lambda } { \lambda } { = } \frac { 1 } { n _ { \mathrm { e f f } } } \frac { d n _ { \mathrm { e f f } } } { d T } \Delta T + \frac { 1 } { \Lambda } \frac { d \Lambda } { d T } \Delta T ,
$$

$$
\frac { \Delta \lambda } { \lambda } = ( \varepsilon _ { \downarrow } + \alpha ) \Delta T ,
$$

where $\Delta \lambda / \lambda$ is the normalized shift of resonance due to change in temperature, $\varepsilon _ { \scriptscriptstyle { b } }$ is the thermo-optic coefficient, and $\alpha$ is the thermal expansion coefficient. For $1 3 3 0 \ \mathrm { n m }$ wavelength, and putting $\varepsilon , \ \alpha$ values of silica, i.e., $6 . 6 \times 1 0 ^ { - 6 } / { } ^ { \circ } \mathrm { C }$ and $0 . 5 5 \times 1 0 ^ { - 6 } / { } ^ { \circ } \mathrm { C }$ , respectively, in Eq. (13), temperature sensitivity obtained is $0 . 0 0 9 4 ~ \mathrm { { n m / ^ { \circ } C } }$ .108 At high temperature, reflectance from germanium-doped silica FBG becomes low. At $3 5 0 \mathrm { K }$ temperature, the FBG failed to show the result and to solve this, a guilded-germanium doped fiber grating sensor was developed, which showed sensitivity of $0 . 0 1 5 7 ~ \mathrm { n m / ^ { \circ } C }$ . 108 At high temperature, it is difficult to record results using bare FBG due to low thermal coefficient of silica. Research has been conducted to improve sensitivity at high temperature using coating on FBG,109 doping of certain material in silica,110 112 formation of stable,113 or using polymer optical fiber. In polymer optical fiber as proposed in Ref. 114, fiber Bragg gratings were inscribed on planer waveguide made of polymer material particularly for high temperature stable sensor. In this study, a single step writing method based on rapid UV is used for fabrication of waveguide and FBG simultaneously. A planer waveguide FBG was made of cyclo-olefin copolymer (COC) samples, which were cut using ultrashort pulse laser and ends were polished. Phase mask technique was used to inscribe gratings on the waveguide. Reflectivity of $9 9 \%$ was achieved with such structure that is suitable for sensing application. Polymers such as PMMA have high affinity to water absorption thereby exhibiting glass transition of up to $9 2 \mathrm { { ^ \circ C } }$ . On the contrary, COC polymer is immune to water absorption making it work even at $1 7 8 \mathrm { { } ^ { \circ } C }$ temperature. Temperature sensitivity of COC polymer-based FBG observed in this study was $- 7 . 7 ~ \mathrm { p m } / ^ { \circ } \mathrm { C }$ . Negative sign indicates negative thermo-optic coefficient of COC polymer. A strong signal was observed even at $1 6 0 . 2 ^ { \circ } \mathrm { C }$ temperature. Another method using polymer optical fiber was discussed in Ref. 115, in which the profile of temperature is detected using chirped fiber Bragg grating (CFBG) written in mPOF during thermal treatments such as thermal ablation of radio frequency. Using phase mask technique CFBG with $0 . 0 9 \ \mathrm { n m / m m }$ chirp rate was inscribed in mPOF. Temperature sensitivity of CFBG measured was $1 0 \ \mathrm { p m } / { } ^ { \circ } \mathrm { C }$ , which causes small amount of bandwidth spectral variation leading to ineffective detection of temperature. Many successful researches have been done in past to enhance its sensitivity. In this study, the temperature sensitivity of $- 1 9 1 . 4 ~ \mathrm { p m / ^ { \circ } C }$ was achieved with CFBG-mPOF. The microstructured POF used here was PMMA having core doped with benzyldimethylketal to increase photosensitivity of fiber. Linear profile of temperature was detected by placing CFBG on heating plate. This study also introduces a spectral reconstruction demodulation technique in which spectra of CFBG is converted to measured temperature in each fringe of grating with $1 \ \mathrm { m m }$ of spatial resolution. Such a narrow spatial resolution provides a benchmark for biomedical applications such as thermotherapies. Another special hybrid polymer, Ormocer, which stands for organically modified ceramic, is an organic– inorganic polymer which was used for sensing temperature in Ref. 116 by inscribing FBG into it using phase mask technique. Ormocer is equivalent to glass having profound thermo-optic coefficient that shows high thermal and chemical stability. High temperature sensitivity of $- 2 5 0 ~ \mathrm { p m } / ^ { \circ } \mathrm { C }$ was obtained with low humidity sensitivity using Ormocer-based FBG sensor.

For high temperature, several technologies involving the fabrication type of FBG have also been evolved in past years that provide FBG operating at elevated temperature. In Ref. 117, four types of gratings in FBG, i.e., types I and IIA, regenerated, femtosecond, sapphire grating were reviewed. Type 1 FBG can operate at temperature ranging $- 2 0 \mathrm { { ^ \circ C } }$ to $8 0 \mathrm { { } ^ { \circ } C }$ but its range can be improved to $6 0 0 ^ { \circ } \mathrm { C }$ by thermal annealing and photosensitization to provide stable gratings. Type In or type IIA is a hydrogen-free silicate fiber that is irradiated with a UV or continuous wavelength laser for extended period of time and can perform at $5 0 0 \mathrm { { } ^ { \circ } C }$ temperature. By giving high intensity exposure to the fiber, temperate range can be extended up to $8 0 0 ^ { \circ } \mathrm { C }$ too. Such type of

FBG does not even require hydrogen loading. Another type called regenerated FBG can operate at a temperature even higher than $8 0 0 ^ { \circ } \mathrm { C }$ , which formed by annealing the seed structure. Such FBG can be effectively used in applications having a harsh environment such as a furnace.118 Also in Ref. 119, an ultrasonic sensor based on regenerated-phase shifted-FBG was designed that could operate at $1 0 0 0 ^ { \circ } \mathrm { C }$ . Femtosecond-based FBG can provide remarkable thermal stability up to $1 0 0 0 ^ { \circ } \mathrm { C }$ due to formation of finer gratings by an ultrafast laser pulse having energy below damage threshold for type I FBG and energy above damage threshold for type II gratings. Above $1 2 0 0 ^ { \circ } \mathrm { C }$ , silica-based FBG becomes inappropriate to use. Sapphire-based FBG is the most successful temperature sensor as sapphire optical fiber has a very high glass transition of $2 0 3 0 ^ { \circ } \mathrm { C }$ and can be written using a femtosecond laser with either a phase mask or point-by-point method.9 In Ref. 120, microsapphire-FBG was presented that could effectively monitor temperature up to $1 4 0 0 ^ { \circ } \mathrm { C }$ . Similarly, in Ref. 121, sapphire-based FBG sensor was used in temperature monitoring of boilers at a commercial power plant (Virginia Tech Central Steam Plant) and was able to measure temperature up to $1 2 0 0 ^ { \circ } \mathrm { C }$ .

Even in the field of oceanography research, there is a need to obtain accurate measurements of temperature and depth of ocean for various applications, such as meteorology, fishing, and navigation. Conventional methods such as piezoelectric and thermistor can be used for measurements but at the cost of low spatial resolution and accuracy. A special encapsulation process was discussed in Ref. 122, where FBG-based sensor was designed that would cancel the effect of pressure and also avoid FBG chirping. This research was carried out at North Yellow Sea, China. Special glue called EPO-TEK 353ND was used to glue the FBG on a metal tube that is usually meant for usage at high temperature. Also, polyvinyl chloride (PVC) thermoplastic was used as external covering, which would reduce the time of response of temperature compensated sensor. Temperature and pressure sensitivity obtained were $2 9 . 8 7 ~ \mathrm { p m / ^ { \circ } C }$ and $1 6 1 1 \mathrm { p m / M p a }$ , respectively.

Not only at highly elevated temperatures FBG fails to operate but also at cryogenic temperature operation of FBG becomes challenging due to low thermal rate of expansion, but this problem can be overcome by using suitable coating.123–125 It was shown in Ref. 126, to measure temperature at multiple places of the high-temperature superconducting magnets efficiently, instead of using conventional multipoint measurement systems like thermocouples and Cernox (Zirconium Oxy-Nitride), which can intrude heat in superconducting magnets, multiple fiber Bragg gratings can be embedded in a single fiber as they have low heat invasions. At cryogenic temperature, FBG contracts, changing the refractive index of core, which eventually causes a shift in Bragg wavelength. But at such a low temperature, the thermal rate of expansion is decreased, which lowers the sensitivity of FBG sensor. In this study, zinc metal was coated over FBG to enhance the thermal rate of expansion owing to its inherent property of high thermal expansion coefficient. Three methods were used to coat zinc over FBG sensor. Sputtering, electroplating after sputtering titanium and copper, electroplating after electro-less nickel plating were the methods used in this study. It was found that electroplating after sputtering titanium and copper was the best method among the three methods. The drawback of this method was the accuracy of thickness as dispersion can take place due to non-uniform coating. Also, durability experiment was performed, which confirmed the ability of sensing cryogenic temperature even under vibration, rapid and repeated cooling. Similar study on cryogenic temperature sensing was proposed in Ref. 127, to increase the capability of measuring temperature at such a low level using various metal coatings over fiber Bragg grating using electro-winning and casting process. Metals like tin, copper, lead, and zinc having high thermal coefficient along with good adhesion were used for coating over FBG. Since copper has a high melting point therefore it cannot be used in casting process. FBG is made of silica and electro-winning process can take place only with conducting metals therefore FBG needs to be pre-coated with metal. A perfect layer of coating was formed with tin, lead and zinc in casting process. Also, less amount of time was involved in casting method. In contrast, electro-winning process is very complex and cumbersome method of depositing low melting temperature metals or metal alloys but they were fabricated thermally stress free at room temperature. It was found in this study that zinc coated fiber Bragg sensor using casting method had high thermal sensitivity and can be used effectively at cryogenic temperature. Table 5 compares various FBG based temperature sensors.

<html><body><table><tr><td>Reference</td><td>Technique</td><td>Inferences</td><td>Packaging</td><td>Application</td></tr><tr><td>195</td><td>Etched FBG coated with molybdenum disulphide (MoS2)</td><td>Temperature sensitivity of 95 pm/C for 10 nm thickness of MoS2 was achieved</td><td>MoS2 coating by magnetron sputtering</td><td></td></tr><tr><td>126</td><td>Zinc-coated FBG</td><td>Able to perform cryogenic sensing with electroless and electroplating zinc on FBG from 280 to 16 K</td><td>Zinc coating by electroplating</td><td>Conduction-cooled superconducting magnet</td></tr><tr><td>196</td><td>Sapphire-based FBG</td><td>Temperature sensing up to 1900°C was obtained</td><td></td><td>Inductive furnace</td></tr><tr><td>121</td><td>Wavelength-multiplexed sapphire FBG</td><td>Temperature sensing up to 1200C was obtained</td><td>High-purity alumina ceramic tube</td><td>Boilers in power plant</td></tr><tr><td>174</td><td>Phase-shifted FBG with femtosecond laser inscription</td><td>Temperature sensitivities of 14.91 pm/C was obtained in the range of 50C to 800℃</td><td></td><td>High temperature environment</td></tr><tr><td>174</td><td>Polymer-based FBG with femtosecond laser inscription</td><td>Temperature sensitivity of -220 pm/C was achieved over a range of 24°C to 40°℃</td><td></td><td>Biosensing,all-fiber devices</td></tr><tr><td>127</td><td>Metal coating with casting and electro-winning method</td><td>Lead showed highest sensitivity</td><td>Lead coating by various methods</td><td>Cryogenic application</td></tr><tr><td>197</td><td>Fiber laser-based FBG</td><td>Temperature sensitivity of 15.9 pm/C for range 300℃ to 1000°C was achieved</td><td></td><td>High temperature applications</td></tr><tr><td>198</td><td>Microfiber Bragg grating</td><td>Proposed sensor when molded with acetal showed high sensitivity of 479.48 pm/C</td><td>Acetal molded FBG</td><td></td></tr><tr><td>122</td><td>Special encapsulation using EPO-TEK 353ND</td><td>Accuracy of 0.01C was reached</td><td>Silica gel coating and bonded with metal structure with adhesive</td><td> Ocean temperature</td></tr><tr><td>199</td><td>Bimetallic configuration</td><td>Temperature sensitivity enhanced to 71.9 pm/C</td><td>Alumina adhesive paste for</td><td></td></tr></table></body></html>

Recently, research on materials other than polymers or metals has also evolved in area of FBG sensors. Since silica fiber is limited to work around $1 6 0 0 \ \mathrm { n m }$ , it fails to provide high sensitivity and large range of operation, which can be offered at the mid-infrared region. In Ref. 128, FBG based on soft glass such as tellurite, chalcogenide, and fluoride was numerically simulated and studied that shows great potential in applications of mid-infrared waveband. Temperature sensitivity of $1 7 5 . 7 ~ \mathrm { p m / ^ { \circ } C }$ was obtained for chalcogenide (arsenic trifluoride, ${ \mathrm { A s } } _ { 2 } { \bf S } _ { 3 }$ ) based fiber, which is higher than silica based FBG having $1 1 . 5 ~ \mathrm { p m } / { } ^ { \circ } \mathrm { C }$ sensitivity. But ${ \mathrm { A s } } _ { 2 } { \mathrm { S } } _ { 3 }$ has low glass transition temperature that is $1 8 5 \mathrm { { } ^ { \circ } C }$ , which limits its high temperature applications. In Ref. 129, a mixed chalcogenide (Ge-Sb-Se) based multimode FBG was theoretically studied. Since refractive index of chalcogenide glass is around 2.0-3.5, they are considered as excellent candidate for multimode FBG. In this study, temperature sensitivity was calculated to be $0 . 0 7 5 8 ~ \mathrm { n m / ^ { \circ } C }$ at $1 5 5 0 \mathrm { n m }$ and $0 . 1 6 ~ \mathrm { { n m } / ^ { \circ } C }$ at $3 3 9 0 \mathrm { n m }$ , which indicates great potential in temperature sensing in the mid-infrared region. Femtosecond laser is the key to fabricate high quality Bragg gratings in such fibers to enable practical application of mid-infrared technology and still further research is required in its fabrication process.130

# 6.4 FBG-Based Liquid Level Sensor

Applications such as oil reservoirs, storage of fuels, sewage treatment plant, chemical processing, and several industries require the need of liquid level measurement. Corrosion and explosion are the biggest concerns while designing a liquid level sensor, which is why electrical based sensors are nowadays seldom used. Optical sensors, mainly FBG, are resistant to corrosion, electrically isolated and intrinsically safe, which serves as a promising technology in accurate measurement of liquid level. As discussed in refractive index based sensors, similar is the concept used here for detection of liquid level by exploitation of evanescent fields of fiber for measuring refractive index. Fibers such as phase shifted fiber, long period grating fiber, and etched fiber are mainly used in past studies for measuring liquid level. Also, FPI-based liquid level sensors have been proposed in Refs. 131 and 132, but one has to compromise with high cost and tedious fabrication process with this technology to achieve high sensitivity. An easy approach is to use FBG technology, which will provide high sensitivity along with easy fabrication.

Liquid level measurement can be derived from pressure measurements using mathematical relations as has been discussed in Ref. 133, where a bourdon tube was used for pressure measurement and was attached with an FBG sensor resulting in monitoring of water column height in terms of hydrostatic pressure. In one study,134 fiber Bragg grating was embedded in diaphragm of epoxy resin. The sensing fiber was placed in close proximity to another reference FBG for temperature sensing to compensate the effect of cross-sensitivity. Pressure applied on the diaphragm induces longitudinal strain on FBG, which estimates measurement of liquid level. Sensitivity of $2 . 8 \ \mathrm { p m / m m }$ was obtained in this experimental work.

Tilted FBG, etched FBG, and no core FBG methods that deals with change in design of fiber or grating can be used for detection of liquid level. Using a TFBG,135 measurement of liquid level and temperature was experimented simultaneously. Bragg resonance response and cladding mode response provides the discrimination of temperature sensing and liquid level sensing. Particularly, change in amplitude of cladding mode is caused due to immersion of FBG in liquid keeping core modes unchanged whereas shift in wavelength is observed for change in temperature, which is sensitive to cladding modes also. In this study, paraffin oil (having refractive index of 1.44) level was measured at varying temperature between $3 0 \mathrm { { ^ \circ C } }$ and $6 0 ^ { \circ } \mathrm { C }$ . Tilted FBG of $1 0 \mathrm { m m }$ length had grating fringe weakly tilted at $3 . 5 ^ { \circ }$ , which made it sensitive to higher refractive index relatively. For higher angle of tilt, sensor sensitivity was observed to decrease. Temperature sensitivity observed was $1 1 . 3 \pm 0 . 1 ~ \mathrm { p m / ^ { \circ } C } .$ . The proposed sensor can be effectively used in broad area of applications such as automobile, food, chemical, and many other industries due to its simple and small structure. An ultrasensitive liquid level sensor was experimentally demonstrated in Ref. 136, using an etched CFBG. Detection of variation of tens of micrometer liquid level with sensitivity of $1 . 2 1 4 ~ \mathrm { n m / m m }$ was achieved with the sensor proposed in this study. Sensing mechanism is such that the evanescent wave is exposed to the surrounding environment by removing the cladding portion of optical fiber using hydro fluoric acid $( 2 0 \% )$ , which greatly enhances the sensitivity. When bare core written with Bragg gratings is immersed in liquid, the refractive index of FBG changes which will further bring variation in Bragg wavelength according to Bragg principle and also at the interface of liquid the phase of Bragg wavelength field changes. Response of spectra remains unchanged for CFBG with air. At interface of air and liquid with CFBG is observed. Liquid level from $0 \mathrm { m m }$ to $5 . 6 ~ \mathrm { m m }$ with increment of $0 . 2 \mathrm { m m }$ was recorded. Linear relation of wavelength shift and liquid level was observed. Also dependence of temperature was studied by varying temperature from $3 0 \mathrm { { ^ \circ C } }$ to $6 0 \mathrm { { ^ \circ C } }$ with $0 . 0 0 8 ~ \mathrm { n m / ^ { \circ } C }$ temperature sensitivity, which hardly requires temperature compensation. Another method where no-core fiber is embedded into a conventional single-mode fiber was used as liquid level indicator in Ref. 137. Bragg gratings were inscribed in one part of the single–mode fiber that will be dipped in liquid. No-core fiber portion sensitive to external refractive index, therefore when the whole fiber is immersed in liquid, the response gets shifted according to the length of no-core fiber immersed. The resonance wavelength of FBG in single-mode fiber should be tuned to region of response of no-core fiber response filter. Intensity based technique is used here for liquid level indication. Sensitivity reported in this study was $0 . 2 5 ~ \mathrm { d B } \mathrm { m m } ^ { - 1 }$ . Similar method of no-core fiber along faraday reflection mirror was used for liquid level sensing using correlation method where FBG is used for filtering the chaotic light from source.138 Table 6 compares various FBG based liquid level sensors.

Table 6 Various FBG-based techniques for liquid level sensing.   

<html><body><table><tr><td>Reference</td><td>Technique</td><td> Inferences</td></tr><tr><td>137</td><td>Multimode interference</td><td>Sensitivity of 0.25 dB mm-1 was achieved</td></tr><tr><td>134</td><td>FBG embedded diaphragm</td><td>Sensitivity of 2.8 pm/mm with low temperature error of 1.04 mm/C was achieved</td></tr><tr><td>138</td><td>Optical chaos</td><td>Linear range of 3.8 cm achieved from 1.0 to 3.8 cm</td></tr><tr><td>136</td><td>Etched chirped FBG</td><td>Sensitivity of 1.214 nm/mm was achieved for tens of micrometer variation</td></tr><tr><td>135</td><td>Tilted FBG</td><td>Sensitivity_of -0.456±0.009 dB mm-1 was achieved for low refractive index</td></tr><tr><td>131</td><td>FBG and Fabry-Perot pressure sensor</td><td>Sensitivity of 0.01491 nm/cm with average measurement error of 0.0323 m was achieved</td></tr></table></body></html>

# 6.5 FBG-Based Pressure Sensor

Force applied on any surface by air or liquid is defined as pressure and is usually measured in Pascal’s. A pressure sensitive element is present in pressure sensor that estimates the actual pressure exerted on it and some components convert it to output signal. Usually, strain-gauge based pressure sensor, capacitive pressure sensor and piezo-electric pressure sensor are used for measuring pressure using deflection method. Because of no electrical isolation and less range of operation, they are seldom used. Use of FBG based sensor is a promising technology for all the range of pressure sensing with high accuracy. Since FBG is written inside the core of fiber, its durability is higher than other optical technologies such as Fabry Perot. Since strain is the effect of pressure, change in Bragg wavelength can be obtained from Eq. (9), though strain caused due to pressure on FBG can be calculated from Eq. (14), where $\mathrm { \bf P }$ is pressure, $\nu$ is poisson’s ratio, and E is Modulus of elasticity:139

$$
\varepsilon = \frac { - \mathrm { P } ( 1 - 2 \nu ) } { \mathrm { E } }
$$

An FBG-based pressure sensor can work under harsh conditions and is still able to provide reasonably high sensitivity. In harsh environments such as thermoelectric power plants, FBG can be used to measure pressure of combustion chamber140 by sealing FBG with electro-less nickel plating. The FBG pressure sensor was able to record pressure of 200 bar at $3 0 0 ^ { \circ } \mathrm { C }$ temperature. Material for fixation is very crucial in harsh conditions as adhesives such as epoxy resin do not function at 200 bar and above, so in this study nickel to nickel was used for fixation as matching of different thermal expansion coefficients is important, which in this case becomes a single material. Similar study discussed in Ref. 141, where choice of material and structural design played an important role in enhancing the sensitivity of FBG based pressure sensor using thin-walled cylinder. Performance analysis of different types of pressure sensors using flexible diaphragm packaging, polymer packaging, and bourdon tube packaging has also been reviewed in this study. However, in this study, thin walled cylindrical packaging is used that induces deformation under the influence of pressure. Beryllium bronze (C17000) having elasticity coefficient of $1 . 3 \times 1 0 ^ { 1 1 }$ Pa and Poisson’s ratio $\mu$ of 0.35 was the material used for making thin walled cylinder. Before fixing the FBG to the thin wall cylinder it was pre-stretched. Pressure sensitivity of $0 . 7 9 4 4 ~ \mathrm { n m / M P a }$ was achieved. The FBG was pulled off after applying pressure of $4 0 \ \mathrm { M P a }$ .

In the health sector, monitoring of vital signs such as blood pressure can also be monitored using FBG,142 where pressure in human arteries was observed as pulse waves and sent to plastic optical fiber-fiber Bragg gratings (POF-FBG). The pulse wave signal from arteries could be detected with signal to noise ratio eight times higher with POF-FBG than with silica-FBG. Similar studies on pressure sensor based on various optical sensors for biomedical applications have been reviewed in Ref. 143. In hydraulic and pneumatic system, there are chances of valve malfunction thus requiring continuous monitoring of pressure change in valves. A pressure sensor was proposed in Ref. 144 using fiber Bragg grating based on thin film for dynamic response measurement of water pressure in tank. The FBG is simply glued to thin film of round substrate for detecting linear variation of pressure without the requirement of hosting material for enhancement of sensitivity. Shift in Bragg wavelength due to change in pressure is calculated using coupled mode theory and thin plate theory. The proposed sensor works well for static, quasi-static, and dynamic water pressure monitoring and is based on static theory of elasticity. Change in wavelength shift with varying pressure levels was linear in relation. Resolution of $2 \mathrm { P a }$ was obtained for dynamic pressure measurements. The proposed FBG based pressure sensor was able to work for a wide range of $0 { - } 1 0 0 0 0 \ \mathrm { P a }$ . Continuous monitoring of concrete pipelines widely used in industries or municipal is required for proper functioning, which can be done with FBG as studied in Ref. 145 where bourdon tube-based FBG pressure sensor was employed, which resulted in pressure sensitivity of $1 . 4 1 4 ~ \mathrm { p m / k P a }$ in range of 0 to $1 \ \mathrm { M P a }$ .

Using fused deposition modeling (FDM) with three-dimensional (3-D) printer in Ref. 146, FBG-based pressure sensor was fabricated for measuring vertical pressure. Fused deposition is a method that is fast, cost effective, and easy to encapsulate optical fiber into sensing structure using raw material. In this study, the raw material used was polyactide (PLA), which is derived from a renewable resource. Using this method, no extra part is wasted during fabrication process. Time required to fabricate the whole sensor structure using FDM was only $5 0 ~ \mathrm { m i n }$ . Inside the pressure sensor, an inner sensing unit was fabricated to ensure high sensitivity of FBG vertical pressure because its small cross sectional is able to generate large deformation. FBG gets elongated when vertical pressure is applied on the sensing unit. FBG was able to survive even at $2 0 0 ^ { \circ } \mathrm { C }$ during FDM process making the sensor feasible for temperature, pressure, or strain sensor. During the process of calibration, the maximum vertical pressure measured was $8 0 0 \mathrm { k P a }$ , and the pressure sensitivity obtained was $4 . 2 6 ~ \mathrm { k P a / p m }$ . Table 7 compares various FBG-based pressure sensors.

# 6.6 FBG-Based Displacement Sensor

Fiber Bragg grating sensors can be used to measure precious parameters such as displacement for enhanced safety and reliability of structures. Especially for maintenance of dynamic performance of structures, it is very essential to monitor shape of the structure at real time. Inclinometer is the most efficient, common, and widely used instrument for measurement of inclined displacement, which can be used in monitoring of infrastructure slopes. Mostly, displacement with an inclinometer is not measured directly but it is calculating in form of strain. Commonly used methods for strain-displacement conversion are conjugate beam method, beam element method, trapezoidal integration method, and difference equation method and are discussed in Ref. 147. Vibration sensing of structures is another aspect of monitoring displacement, which again needs strain-displacement relation. In Ref. 148, structural vibrations were monitored using four FBG with aluminum and acryl beam specimen where strain-displacement relationship was formed.

Table 7 Various FBG-based techniques for pressure sensing.   

<html><body><table><tr><td>Reference</td><td>Technique</td><td>Inferences</td><td>Packaging</td><td>Application</td></tr><tr><td>140</td><td>Nickel-plated FBG</td><td>Able to monitor pressure of 200 barat300℃</td><td>Nickel coating by electroless method</td><td>Thermoelectric power plant engines</td></tr><tr><td>146</td><td>FBG using FDM</td><td>Pressure sensitivity of 4.26 kPa/pm achieved</td><td>FBG fused inside melted PLA</td><td>Monitoring of soil pressure</td></tr><tr><td>141</td><td>Thin walled cylinder</td><td>Pressure sensitivity of 0.079 nm/MPa with linearity of 0.999 was achieved</td><td>FBG pasted on circumference of thin walled cylinder</td><td></td></tr><tr><td>145</td><td>Bourdon tube</td><td>Pressure sensitivity of 1.414 pm/kPa in the rangeresin of O to 1 MPa achieved</td><td>Bonded with epoxy</td><td>Pipeline leakage detection</td></tr><tr><td>200</td><td>Rubber-based diaphragm</td><td>Pressure sensitivity of 117.7 pm/kPa for range of 40 kPa was achieved</td><td>FBG bonded on rubber diaphragm</td><td>Low-pressure detection</td></tr><tr><td>144</td><td>Thin film</td><td>Static pressure of range within 5 Pa with resolution of 2 Paachieved</td><td>FBG bonded on thin film</td><td>Monitoring of water pressure in tank</td></tr><tr><td>169</td><td>Plane diaphragm</td><td>Pressure sensitivity of 46.62 pm/MPa achieved</td><td>FBG pasted using epoxy resin</td><td>Mining and civil engineering applications</td></tr><tr><td>201</td><td>Piston-like diaphragm</td><td>Pressure responsivity of 7 nm/MPa is achieved</td><td>FBG encapsulated in metal cylinder</td><td>Pressure detection in hydrophone</td></tr><tr><td>202</td><td>Femtosecond laser- induced microstructured FBG</td><td>Pressure range from 15 to 2000 psi was measured at 800C temperature</td><td>FBG sealed in stainless steel tube</td><td>Fossil fuel and nuclear energy application</td></tr><tr><td>203</td><td>Femtosecond laser- induced tapered-FBG</td><td>Hydrogen pressure sensor Palladium coating having sensitivity of 0.15 pm/kPa was obtained for0to780kParange</td><td></td><td>Hydrogen pressure detection</td></tr></table></body></html>

Sensing of displacement at mili-, micro-, or nanoscale is difficult to achieve with high resolution. For instance monitoring of soil displacement as discussed in study149 was based on FBG was developed for measurement of soil deformation. A single FBG fixed between two anchorage plates was designed to sense minor displacement of soil deformation causing the two anchorage plates to displace, which induces strain on the fiber Bragg grating. FBG was encased in PVC for protection. FDM was used to fabricate the anchorage plate and fix FBG onto it. As discussed earlier, FDM is a very easy and quick method to fabricate certain models or structures. Polyactic acid was used as a raw material to make anchorage plates with FDM process. Calibration test was also performed where range of FBG displacement was found to be 0 to $0 . 9 \ \mathrm { m m }$ , and resolution of minimum displacement obtained was $0 . 0 7 4 7 \ \mathrm { \ m m }$ . The maximum displacement obtained for horizontal direction was $< 0 . 0 3 \ \mathrm { m m }$ using FBG-based displacement sensor. This type of sensor can be used very effectively for indicating the flow of vehicles on road and also the type of vehicle depending on the amount of wavelength shift. Fabrication of such sensor greatly helps researchers and engineers for better understanding of soil underlying used in various applications. Vertical displacement is very crucial and difficult to estimate for various heavy structures such as buildings, dams, and bridges. Displacement measurement of long bridges can be easily monitored using FBG and its distributed sensing property as discussed in Ref. 150, where a set of FBG-differential settlement measurement sensors, connected by a hydrostatic leveling system of communicating vessels were used for displacement measurements along a large-scale prestressed concrete beam. This experiment was demonstrated on a highway bridge in Taiwan.

Even in SHM of offshore structures such as wellheads, flow-lines, jumpers, and subsea manifolds, positioning of sensors becomes very vital for measurements because of complex structures. Therefore, FBG can be very helpful in maintaining the alignment of various sensors with high precision,151 using cantilever beam with which displacement of microscale can be achieved. The amount of displacement is calculated mathematically from the strain–wavelength relation of FBG.

Next-generation robots are being developed using soft robotics, which generally involves flexible actuators and structures. Soft robotics can be applied to various biomedical applications such as prostheses or orthosis. In a biomedical area, stiffness reduction of robots is of prime concern, which can be achieved by a series of elastic actuator conventionally. Similar output can be obtained using polymer optical fiber-FBG reported in Ref. 152, where multiple FBG written in CYTOP were employed in a series elastic actuator spring for displacement measurement. Assessing the movement of joint in body is crucial in medical practice and the latest study was conducted where stiffness and angular displacement of first metatarsophalangeal joint was recorded using FBG and load cell.15 3 This technique opens up future investigation in the medical field due to enhanced accuracy. For accurate results, high resolution is required, which can be obtained using wavelength scanning laser,154 which works on scanning of radio frequency signal. This method measures displacement at a microscale level and gives resolution of nanometer using two FBG, which forms FPI cavity. Similarly, a submicrometer resolution was obtained along with additional advantage of no chirping failure caused due to FBG pasting process. This was achieved in a study155 where T-shaped cantilever and wedge-shaped sliding block were employed in the setup that helped in transferring the displacement to FBG sensor precisely. The results showed resolution of $0 . 4 8 \ \mu \mathrm { m }$ for 1 to $2 \mathrm { m m }$ range. A nearly equal amount of resolution of 0.495 was achieved in Ref. 155 again for submicron displacement using FBG. Also, temperature compensation was provided by keeping a free FBG near to sensing FBG. Chirp phenomenon was also removed in Ref. 156, using two FBG on two cylindrical rods prestretched. Sensitivity of $3 3 0 4 . 7 ~ \mathrm { p m / m m }$ and resolution of $2 0 \ \mu \mathrm { m }$ were achieved in this study. Apart from SHM of various structures, FBG can also be used in biomechanical application such as displacement monitoring of tendons and ligaments.157 Since conventional implantable transducers for strain measurements on tendon or ligament are costly and difficult to implement, FBG serves as a good alternate that is cheap and easy to implement. Variation in length of ligament and tendon under load was measured using etched FBG embedded in microshaped memory alloy tube. Table 8 compares various FBG-based displacement sensors.

# 6.7 FBG-Based Shape Sensing

Fiber Bragg grating has recently emerged in the area of shape sensing, which is very crucial in medical applications. Biopsy, colonoscopy, cardiac procedures, and many more diagnostic procedures require accurate spatial information of instruments used on patients. Ultrasound and fluoroscopy are also used in some cases such as in epidural administration, but these procedures are harmful as the patient is exposed to radiation. Optical fiber sensors can be used as an alternate to these methods that can provide better spatial information. Endoscopes and many catheters comprise optical fiber that goes well with medical instruments as they are small in size and free from radiation. A review on developments recently made in shape sensing using optical fiber is present in Ref. 158. Placing of a catheter in epidural, urinary tract, displaying shape of colon, or real-time imaging of needle shape involves critical shape monitoring, which can be achieved by FBG sensor that can convert force arising between tissues while aiding the medical instrument. Fiber Bragg gratings convert the change in curvature of fiber to wavelength shift given as159

$$
\Delta { { \lambda } _ { B } } = { { k } _ { i } } { { \lambda } _ { B } } ( 1 - { { P } _ { e } } ) d / 2 ,
$$

where $k _ { i }$ is the curvature, $P _ { e }$ is the effective elastic coefficient of the fiber, $\Delta \lambda _ { B }$ is the wavelength change, and $d$ is the distance of the fiber grating to the neutral plane.

<html><body><table><tr><td>Reference</td><td>Technique</td><td>Inferences</td><td>Packaging</td><td>Application</td></tr><tr><td>204</td><td>FBG with linear variable displacement transformers</td><td>As loading increased, cracks appeared and displacement was obtained at the joint of dam model</td><td>FBG is fixed in groove structure with epoxy resin</td><td>Dam displacement monitoring</td></tr><tr><td>154</td><td>Hybrid fiber Bragg grating-FBl</td><td>Sensitivity achieved for the proposed sensor is 35.7 MHz/μm</td><td></td><td>Monitoring of microdisplacement with ultrahigh resolution</td></tr><tr><td>155</td><td>Wedge-shaped sliding block and T-shaped cantilever</td><td>Sensitivity of 2086.27 pm/mm with high resolution of 0.48 μm achieved</td><td>Prestressed FBG bonded on frame from ends</td><td>Submicron deformation detection</td></tr><tr><td>205</td><td>Balloon-shaped bent single-mode fiber in long period gratings</td><td>Displacement sensitivity of -306 pm/μm for range 0 to 80 μm was achieved</td><td>Silica capillary tube encapsulation</td><td></td></tr><tr><td>149</td><td>Anchorage plate and PVC tube</td><td>Minimum displacement resolution of 0.0747 mm obtained for maximum displacement range of 0 to 0.9 mm</td><td>FBG sealed with PVC tube</td><td>Soil deformation monitoring</td></tr><tr><td>156</td><td>FBG in cylindrical rods</td><td>Sensitivity of 3304.7 pm/mm achieved with accuracy of 20 μm</td><td>Prestressed FBG bonded from ends only</td><td>Crack monitoring</td></tr><tr><td>152</td><td>Elastic_actuator spring using CYTOP fiber</td><td>Sensitivity is increased by eight times using CYTOP-based fibergrating</td><td>FBG pasted on spring with thermoplastic glue</td><td>Flexible structures,soft robotics</td></tr><tr><td>206</td><td>Three point bending technique</td><td>For displacement of 6 mm and calibration factor of -0.495 μm/mm,wavelength shift of 12.12 nm was obtained</td><td>FBG bonded on beam</td><td>Crack monitoring</td></tr><tr><td>150</td><td>Differential-settlement measurement</td><td>Able to measure displacement with fully loaded four trucks</td><td>Acrylate-coated FBG encapsulated in container</td><td>Bridge displacement monitoring</td></tr></table></body></html>

In Ref. 63, a real-time shape monitoring FBG sensor was presented having space division multiplex-wavelength division multiplex sensing network of 20 FBG for colonoscopy. Many studies have been conducted using single-core FBG for shape sensing160 since they are cheap but recently multicore FBG sensors have started replacing them even though they are more expensive. The reason is smaller cross-section of multicore fibers that allow them to function precisely in medical environment. Also, the shape sensing was earlier performed using three fibers in triangular configuration161 on the structure, but it introduces certain error in measurements due to change in core geometry, which now has been overcome by use of multicore fiber. In multicore fiber, multiple single core fibers are mechanically coupled inside the fiber keeping relative distance between them constant. In Ref. 162, multicore-based FBG was used in shape sensing of flexible instruments used the in medical field. The strain induced on FBG is converted to torsion, bend, or curvature for measurement of shape of instrument on which FBG is bonded. The shape of instrument is usually obtained by solving Frenet–Serret equation,163 but this equation fails for shape sensing of flexible instruments since torsion is not defined in flexible structures. Parallel transport method164 and circle segment method165 were proposed to resolve this problem. Also, in Ref. 166, using multicore FBG, flexible shape sensor for endovascular navigation was designed. Tools required for robotics, biomedical for invasive surgery, or health monitoring application need be to mechanically durable and therefore in Ref. 167, a polyimide coated multicore FBG was proposed for shape sensing in harsh environment. The durability of this sensor was made high by coating the fiber with polyimide and also by fabricating the gratings using a femtosecond laser that mechanically strengthened the fiber sensor. To improve shape reconstruction accuracy, which is critical in medical instrument, many algorithms are implemented, such as piecewise constant curvature and torsion assumption with FBG.168 Recently, an updated reconstruction algorithm was proposed based on single-point recursive reconstruction159 in which error in curvature calculations was greatly improved. Such algorithms can be used not in medical applications but also in potential applications such as real-time measurement of soil deformation or wing deformation structure.

# 7 Temperature Compensation Techniques in FBG

Fiber Bragg gratings are sensitive to all the external stimulus, such as temperature, strain, and pressure at the same time. If strain is applied on FBG with varying ambient temperature, Eq. (16) is obtained which indicates combined effect of temperature and strain:

$$
\Delta \lambda _ { B } = [ \lambda _ { B } ( 1 - P _ { e } ) \Delta \varepsilon ] + [ \lambda _ { B } ( \alpha + \varepsilon _ { \iota } ) \Delta T ] .
$$

In Eq. (13), the second term induces additional shift in wavelength that will present miscalculated shift in Bragg wavelength. Therefore, problem of cross-sensitivity can occur, which can create error in sensing the parameter of interest. Due to temperature cross-sensitivity of FBGs, the wavelength shift of an FBG sensor is generally a coproduct temperature and the parameter being measured. Therefore, temperature compensation is required. Below are a few techniques described that were successfully performed by researchers in compensating temperature.

In Ref. 169, FBG-based temperature compensated pressure sensor was designed using plane diaphragm. In the sensor design, two FBG are used to separately calculate the wavelength shift of temperature and pressure (with temperature effect also). The FBG for temperature measurement only is connected to pressure sensing FBG through a coupler. Both FBG were placed very close to each other so that the same magnitude of temperature can be recorded.

In Ref. 170, different encapsulation methods were discussed for temperature compensation. In the first method, two similar FBG were pasted on the opposite side of elastomer, which would result in positive and negative strain induced due to compressive and tensile strain. Also, the wavelength shifts would include shift from temperature. The subtraction of both wavelength shifts will result in shift from temperature, which can be thus removed. Another method is simply the modification of the first method where the two FBG were prestretched before being pasted on both sides of elastomer. Prestretching helps in removing the chirping phenomenon, which is caused in FBG due to nonuniform distribution of strain. Second method showed better results.

Adding one reference FBG in close proximity to sensing FBG was also one method discussed where reference FBG records the shift from temperature only as it is left free with no influence of strain.

In Ref. 171, a discrimination technique for strain and temperature was implemented simply by writing FBG over EDF’s core. FBG was written over EDF using phase mask technology after the core of EDF was hydrogenated to increase photosensitivity. The gain of EDF is a linear function of temperature. Therefore, as the temperature is varied, the dips in wavelength transmission spectrum will vary linearly. Strain values are discriminated by the amount of shift in wavelength. Temperature and strain sensitivities observed in this study were $1 2 \ \mathrm { p m } / { } ^ { \circ } \mathrm { C }$ and $0 . 8 ~ \mathrm { p m } / \mu \mathrm { m }$ , respectively.

In Ref. 172, temperature compensated pressure sensor was designed with pressure sensitivity of $1 . 8 \times 1 0 ^ { - 2 }$ per MPa. Here, FBG was strained axially by surrounding pressure, and temperature is compensated using effect of bimetal. Initially, FBG is tightly stretched and when temperature rises, blueshift is produced. Thermally induced redshift compensates for the blueshift, which results in pure pressure measurement.

In Ref. 173, Kalman filter was used to compensate the effect of temperature in FBG-based manometer. Two FBG were used to construct a catheter for manometry, one for temperature only and other for pressure sensing. Autoregression model was developed to compensate temperature by fitting this model to the difference between the two signals from different FBG and using Kalman filter corresponding coefficients were measured. Autoregression model estimates the signal from the pressure signal measured and the difference signal, which is then added to the temperature signal to estimate compensated signal.

In Ref. 174, Bragg gratings were inscribed in MOF and subsequently reduced thermal variation in Bragg wavelength. Temperature was compensated by adding a liquid of refractive index having appropriate thermal dependence in the holes of MOF. Using this method, thermal variations were reduced by a factor of 4 in a six-hole MOF for temperature ${ > } 2 0 ^ { \circ } \mathrm { C }$ .

In Ref. 47, CFBG was used to discriminate temperature with strain using it partially with glass tube made of silica. A portion of longer grating of CFBG was embedded and attached with silica tube, and the shorter grating portion was left uncovered. A glass tube made of silica has the same temperature response as that of CFBG but does not respond to strain perturbations. Strain response is given by unattached CFBG portion, which also include the combined response of temperature. The temperature response from the attached glass tube can be subtracted from the combined response of unattached CFBG will give only strain response.

In Ref. 175, an FBG strain sensor was proposed based on cantilever beam made of bimetallic material to compensate temperature. Such a package sensor is very simple and compact, with no additional circuitry or component involved. Such a sensor is able to reduce the wavelength shift induced due to temperature by more than one order of magnitude. Two bimetallic strips of different coefficient of thermal expansion (CTE) were joined together in parallel, and FBG was attached at two points (ends of FBG) onto the metal having lower CTE. Strain is transferred from metal having higher CTE to metal having lower CTE and further transferred to FBG when temperature is applied. Using this technique, temperature dependence of Bragg wavelength was reduced by $- 0 . 4 ~ \mathrm { p m } / ^ { \circ } \mathrm { C }$ .

# 8 Conclusion

Fiber Bragg gratings rapidly shifted from the interest of research laboratories to actual implementation in optical sensor systems after its development. It may become tough to think of sensor systems without implementation of fiber Bragg gratings owing to its attractive features. In this review paper, an overview of fundamentals of fiber Bragg gratings and its progress in designing of sensor for various physical parameters, such as temperature, strain, pressure, liquid level, refractive index, and displacement, was reviewed. Because of inherent advantages of FBG such small size, high sensitivity, dynamic range, fast response, and electrical isolation, it becomes a promising technology in area of sensing. Employing FBG along with other advance optical technologies will result in overall enhancement of sensor design in terms of sensitivity, performance, cost, and size.

# References

filter fabrication,” Appl. Phys. Lett. 32(10), 647–649 (1978).   
2. K. O. Hill and G. Meltz, “Fiber Bragg grating technology fundamentals and overview,” J. Light. Technol. 15(8), 1263–1276 (1997).   
3. A. D. Kersey et al., “Fiber grating sensors,” J. Lightwave Technol. 15(8), 1442–1463 (1997).   
4. M. M. Werneck et al., A Guide to Fiber Bragg Grating Sensors, Current Trends in Shortand Long-Period Fiber Gratings, C. Cuadrado-Laborde, Ed., IntechOpen, pp. 1–24 (2013).   
5. W. Morey, G. Meltz, and H. Glenn, “Fiber optic Bragg grating sensors,” Proc. SPIE 1169, 98 (1989).   
6. T. Erdogan, “Fiber grating spectra,” J. Lightwave Technol. 15(8), 1277–1294 (1997).   
7. A. Othonos et al., “Fiber Bragg gratings,” in Wavelength Filters in Fibre Optics, H. Venghaus, Ed., pp. 189–269, Springer, Berlin, Heidelberg (2006).   
8. B. A. Tahir, J. Ali, and R. A. Rahman, “Fabrication of fiber grating by phase mask and its sensing application,” J. Optoelectron. Adv. Mater. 8(4), 1604–1609 (2014).   
9. S. J. Mihailov, 6 – Femtosecond Laser-Inscribed Fiber Bragg Gratings for Sensing Applications, Elsevier Inc., National Research Council of Canada, Ottawa, Ontario, Canada (2018).   
10. K. Zhou et al., “Line-by-line fiber Bragg grating made by femtosecond laser,” IEEE Photonics Technol. Lett. 22(16), 1190–1192 (2010).   
11. P. Lu et al., “Plane-by-plane inscription of grating structures in optical fibers,” J. Lightwave Technol. 36(4), 926–931 (2018).   
12. A. Theodosiou et al., “Plane-by-plane femtosecond laser inscription method for singlepeak Bragg gratings in multimode CYTOP polymer optical fiber,” J. Lightwave Technol. 35(24), 5404–5410 (2017).   
13. H. Attori et al., “Plane-by-plane femtosecond laser inscription of first-order fiber Bragg gratings in fluoride glass fiber for in situ monitoring of lasing evolution,” Opt. Express 26(25), 33305–33313 (2018).   
14. J. Habel et al., “Femtosecond FBG written through the coating for sensing applications,” Sensors 17, 2519 (2017).   
15. Y. Wang, “Review of long period fiber gratings written by $\mathrm { C O } _ { 2 }$ laser,” J. Appl. Phys. 108, 081101 (2010).   
16. Y. Wang, D. N. Wang, and W. Jin, ${ } ^ { \mathfrak { s } } \mathrm { C O } _ { 2 }$ laser-grooved long period fiber grating temperature sensor system based on intensity modulation,” Appl. Opt. 45(31), 7966 (2006).   
17. R. C. Chaves et al., “Strain and temperature characterization of LPGs written by $\mathrm { C O } _ { 2 }$ laser in pure silica LMA photonic crystal fibers,” Photonic Sens. 5(3), 241–250 (2015).   
18. Y. Wang et al., “Long period gratings in air-core photonic bandgap fibers,” Opt. Express 16(4), 2784–2790 (2008).   
19. G. Guo, “Superstructure fiber Bragg gratings for simultaneous temperature and strain measurement,” Opt. – Int. J. Light Electron Opt. 182, 331–340 (2019).   
20. G. Brambilla et al., “Photochemical long-period grating fabrication in pure-fused-silica photonic crystal fiber,” in Lasers and Electro-Opt., 2007 and the Int. Quantum Electron. Conf., pp. 1 (2007).   
21. H. E. Joe et al., “A review on optical fiber sensors for environmental monitoring,” Int. J. Precis. Eng. Manuf. – Green Technol. 5(1), 173–191 (2018).   
22. S. Kher and M. K. Saxena, Distributed, Advanced Fiber Optic Sensors, IntechOpen (2019).   
23. D. Tosi, “Review of chirped fiber Bragg grating (CFBG) fiber-optic sensors and their applications,” Sensors 18, 2147 (2018).   
24. R. Min et al., “Optical fiber technology microstructured PMMA POF chirped Bragg gratings for strain sensing,” Opt. Fiber Technol. 45(June), 330–335 (2018).   
25. T. Guo et al., “Optics and laser technology tilted fiber grating mechanical and biochemical sensors,” Opt. Laser Technol. 78, 19–33 (2016).   
26. J. Albert, L. Shao, and C. Caucheteur, “Tilted fiber Bragg grating sensors,” Laser Photonics Rev. 26, 1–26 (2012).   
27. A. Martinez-rios et al., “Long period fibre gratings,” in Fiber Optic Sensors, M. Yasin, S. W. Harun, and H. Arof, Eds., IntechOpen (2012).   
28. Y. Zhao et al., “Torsion, refractive index, and temperature sensors based on an improved helical long period fiber grating,” J. Lightwave Technol. 38(8), 2504–2510 (2019).   
29. T. Hiroshi and U. Kei, “Characterization of long-period grating refractive index sensors and their applications,” Sensors 9, 4559–4571 (2009).   
30. T. Liu and M. Han, “Analysis of $\pi$ -phase-shifted fiber Bragg gratings for ultrasonic detection,” IEEE Sens. J. 12(7), 2368–2373 (2012).   
31. K. Nakagawa et al., “Phase-shifted fiber Bragg gratings fabrication method,” J. Phys.: Conf. Ser. 1038, 012095 (2018).   
32. A. Cusano, D. Paladino, and A. Iadicicco, “Microstructured fiber Bragg gratings,” J. Lightwave Technol. 27(11), 1663–1697 (2009).   
33. F. Berghmans et al., “Microstructured optical fiber Bragg grating sensors for structural health monitoring applications,” in 7th Eur. Workshop Struct. Health Monitor., pp. 962–969 (2014).   
34. C. Broadway et al., “Towards commercial polymer fiber Bragg grating sensors?: review and applications,” J. Lightwave Technol. 37(11), 1–11 (2018).   
35. C. Y. Wei, “The influence of hydrogen loading and the fabrication process on the mechanical strength of optical fibre Bragg gratings,” Opt. Mater. (Amst). 20, 241–251 (2002).   
36. W. A. Reed, “High pressure hydrogen loading as a technique for achieving ultrahigh UV photonsitivity and thermal sensitivity in $\mathrm { G e O } _ { 2 }$ doped optical fibres,” Electron. Lett. 29(13), 7–9 (1993).   
37. A. G. Simpson et al., “Type 1A fibre Bragg grating photosensitivity and the development of optimum temperature invariant type I–type IA strain sensors,” Proc. SPIE 5459, 118–127 (2004).   
38. C. W. Smelser, S. J. Mihailov, and D. Grobnic, “Formation of type I-IR and type II-IR gratings with an ultrafast IR laser and a phase mask formation of type I-IR and type II-IR gratings with an ultrafast IR laser and a phase mask,” Opt. Express 13(14) (2005).   
39. X. Shu et al., “Dependence of temperature and strain coefficients on fiber grating type and its application to simultaneous temperature and strain measurement,” Opt. Lett. 27(9), 701–703 (2002).   
40. M. Mccall, “On the application of coupled mode theory for modeling fiber Bragg gratings,” J. Lightwave Technol. 18(2), 236–242 (2000).   
41. R. Kashyap, Principles of Optical Fiber Grating Sensors, 2nd ed., Academic Press, École Polytechnique de Montréal, University of Montréal, Montréal, Canada (2010).   
42. K. Ogawa et al., “Wireless, portable fiber Bragg grating interrogation system employing optical edge filter,” Sensors 19, 3222 (2019).   
43. U. Tiwari, K. Thyagarajan, and M. R. Shenoy, “EDF-based edge-filter interrogation scheme for FBG sensors,” IEEE Sens. J. 13(4), 1315–1319 (2013).   
44. D. Srivastava et al., “Intensity modulation using chirped fiber Bragg grating as an edge filter for temperature sensing,” Microwave Opt. Technol. Lett. 56(12), 2913–2915 (2014).   
45. C. A. R. Díaz et al., “A cost-effective edge- filter based FBG interrogator using catastrophic fuse effect micro-cavity interferometers,” Measurements 124, 486–493 (2018).   
46. P. C. Silveira et al., “Experimental evaluation of low-cost interrogation techniques for FBG sensors,” in IEEE Int. Instrum. and Meas. Technol. Conf. (I2MTC), Houston, Texas, pp. 1–7 (2018).   
47. S. Kim et al., “Temperature-independent strain sensor using a chirped grating partially embedded in a glass tube,” IEEE Photonics Technol. Lett. 12(6), 678–680 (2000).   
48. J. Alves et al., “Fiber Bragg sensor interrogation system based on a CCD spectrometer,” in SENSORS, 2003 IEEE, Toronto, Ontario, Vol. 2, pp. 909–913 (2003).   
49. J. Park et al., “Dynamic fiber Bragg grating strain sensor interrogation with real-time measurement,” Opt. Fiber Technol. 38, 147–153 (2017).   
50. J. E. Posada-Roman et al., “Fast interrogation of fiber Bragg gratings with electro-optical dual optical frequency combs and measurement,” Sensors 16, 1–11 (2007).   
51. A. V. Harish et al., “Dynamic interrogator for elastic wave sensing using Fabry Perot filters based on fiber Bragg gratings,” Ultrasonics 60, 103–108 (2015).   
52. X. Li et al., “FBG sensing demodulation technology based on acousto-optic tunable filter,” Appl. Mech. Mater. 517, 4257–4260 (2014).   
53. A. D. Kersey, T. A. Berkoff, and W. W. Morey, “Multiplexed fiber Bragg grating strainsensor system with a fiber Fabry–Perot wavelength filter,” Opt. Lett. 18(16), 1370–1372 (1993).   
54. A. D. Kersey and M. J. Marrone, “Fiber Bragg grating high-magnetic-field probe,” in Tenth Int. Conf. Opt. Fiber Sens., pp. 53–56 (1994).   
55. A. T. Alavie et al., “A multiplexed Bragg grating fiber laser sensor system,” IEEE Photonics Technol. Lett. 5(9), 1112–1114 (1993).   
56. F. T. S. Yu and S. Yin, Fiber Optic Sensors, Taylor and Francis, Boca Raton (2002).   
57. Y. Dai et al., “Time division multiplexing of FBG sensor system,” Proc. SPIE 7375, 1–5 (2009).   
58. Y. Dai et al., “A novel time-division multiplexing fiber Bragg grating sensor interrogator for structural health monitoring,” Opt. Lasers Eng. 47(10), 1028–1033 (2009).   
59. L. C. S. Nunes et al., “FBG sensor multiplexing system based on the TDM and fixed filters approach,” Sens. Actuators A. Phys. 138, 341–349 (2007).   
60. W. H. Chung et al., “Time- and wavelength-division multiplexing of FBG sensors using a semiconductor optical amplifier in ring cavity configuration,” IEEE Photonics Technol. Lett. 17(12), 2709–2711 (2005).   
61. Y. Rao, “In-fibre Bragg grating sensors,” Meas. Sci. Technol. 8, 355–375 (1997).   
62. Y. Rao et al., “Spatially-multiplexed fibre-optic Bragg grating strain and temperature sensor system based on interferometric wavelength-shift detection,” Electron. Lett. 31(12), 1009–1010 (1995).   
63. L. Zhang et al., “On SDM/WDM FBG sensor net for shape detection of endoscope,” in Proc. IEEE Int. Conf. Mechatron. and Autom., Niagara Falls, Canada, pp. 1986–1991 (2005).   
64. D. Liu et al., “Research progress in the key device and technology for fiber optic sensor network,” Photonic Sens. 6(1), 1–25 (2016).   
65. P. K. C. Chan et al., “FMCW multiplexing of fiber Bragg grating sensors,” IEEE J. Sel. Top. Quantum Electron. 6(5), 756–763 (2000).   
66. X. Lu, P. J. Thomas, and J. O. Hellevang, “A review of methods for fibre-optic distributed chemical sensing,” Sensors 19, 2876 (2019).   
67. F. Chiavaioli et al., “Biosensing with optical fiber gratings,” Nanophotonics 6(4), 663–679 (2017).   
68. G. Tsigaridas et al., “Theoretical and experimental study of refractive index sensors based on etched fiber Bragg gratings,” Sens. Actuators A. Phys. 209, 9–15 (2014).   
69. T. Geng et al., “A temperature-insensitive refractive index sensor based on no-core fiber embedded long period grating,” J. Lightwave Technol. 35(24), 5391–5396 (2017).   
70. Y. Zhao et al., “Sensing characteristics of long-period fiber gratings written in thinned cladding fiber,” IEEE Sens. J. 16(5), 1217–1223 (2016).   
71. Q. Shi et al., “Resolution-enhanced fiber grating refractive index sensor based on an optoelectronic oscillator,” IEEE Sens. J. 18(23), 9562–9567 (2018).   
72. A. Rosenthal, D. Razansky, and V. Ntziachristos, “High-sensitivity compact ultrasonic detector based on a pi-phase-shifted fiber Bragg grating,” Opt. Lett. 36(10), 1833–1835 (2011).   
73. Z. Zhang, T. Guo, and B. Guan, “Reflective fiber-optic refractometer using broadband cladding mode coupling mediated by a tilted fiber Bragg grating and an in-fiber mirror,” J. Lightwave Technol. 37(11), 2815–2819 (2019).   
74. C. E. Campanella et al., “Fibre Bragg grating based strain sensors?: review of technology and applications,” Sensors 18, 3115 (2018).   
75. K. Li, “Review of the strain modulation methods used in fiber Bragg grating sensors,” J. Sens. 2016, 1–9 (2016).   
76. D. Li, L. Ren, and H. Li, “Mechanical property and strain transferring mechanism in optical fiber sensors,” in Fiber Optic Sensors, M. Yasin, S. W. Harun, and H. Arof, Eds., IntechOpen (2012). roc (2015).   
78. K. Feng and J. Cui, “Analysis and simulation method of the cantilever FBG sensors,” Proc. SPIE 9903, 99031E (2016).   
79. C. R. Giles, “Lightwave applications of fiber Bragg gratings,” J. Lightwave Technol. 15(8), 1391–1404 (1997).   
80. M. Kang, D. Park, and S. Lee, “Strain measurements on a cantilever beam with fiber Bragg grating sensors using a pair of collimators,” Int. J. Precis. Eng. Manuf. 13(3), 455–458 (2012).   
81. M. Liu et al., “A high sensitivity FBG strain sensor based on flexible hinge,” Sens. Actuators A. Phys. 19, 1931 (2019).   
82. L. Yi and Y. Changyuan, “Highly stretchable hybrid silica/polymer optical fiber sensors for large-strain and high-temperature application,” Opt. Express 27(15), 20107–20116 (2019).   
83. I. Lazar et al., “Long-term strain response of polymer optical fiber FBG sensors,” Opt. Mater. Express 7(3), 967–976 (2017).   
84. D. K. Mynbaev and L. L. Scheiner, Fiber-Optic Communications Technology, Indian Edition, Pearson Education Asia (2001).   
85. R. U. I. M. In et al., “Inscription of Bragg gratings in undoped PMMA mPOF with Nd?: YAG laser at $2 6 6 ~ \mathrm { { n m } }$ wavelength,” Opt. Express 27(26), 38039–38048 (2019).   
86. I. Johnson et al., “Optical fibre Bragg grating recorded in TOPAS cyclic olefin copolymer,” Electron. Lett. 47(4), 271–272 (2011).   
87. M. Rosenberger et al., “TOPAS based humidity insensitive polymer planar Bragg gratings for temperature and multi-axial strain sensing,” Proc. SPIE 9444, 1–6 (2015).   
88. R. Oliveira, T. H. R. Marques, and C. M. B. Cordeiro, “Strain sensitivity enhancement of a sensing head based on ZEONEX polymer FBG in series with silica fiber,” J. Lightwave Technol. 36(22), 5106–5112 (2018).   
89. K. Henrik et al., “Fabrication and characterization of polycarbonate microstructured polymer optical fibers for high-temperature-resistant fiber Bragg grating strain sensors,” Opt. Mater. Express 6(2), 649–659 (2016).   
90. C. A. F. M. Arques et al., “Fast and stable gratings inscription in POFs made of different materials with pulsed 248 nm KrF laser,” Opt. Express 26(2), 272–281 (2018).   
91. J. Bonefacino et al., “Ultra-fast polymer optical fibre Bragg grating inscription for medical devices,” Nat. Publ. Gr. 7(3), 17110–17161 (2018).   
92. S.-F. Jiang, Z.-H. Qiao, and J.-B. Luo, “Structural health monitoring system based on FBG sensing technique for Chinese ancient timber buildings,” Sensors 110(20), 1–17 (2019).   
93. Y. Qiu et al., “Applications of FBG sensors for airship structural health monitoring,” in Photonics and Optoelectron. (SOPO), pp. 1–3 (2012).   
94. L. Gao et al., “Strain monitoring of combustible gas implosion test based on fiber Bragg grating,” Shock Vib. 2019, 1–17 (2019).   
95. Z. Xiong et al., “Evaluation and identification of dynamic strain on a blast door subjected to blast loading using fibre Bragg grating sensors,” Int. J. Distrib. Sens. Networks 14(3), 155014771876686 (2018).   
96. Y. Hu et al., “A monitoring and warning system for expressway slopes using FBG sensing technology,” Int. J. Distrib. Sens. Networks 14(5), 1–12 (2018).   
97. O. Almubaied et al., “Monitoring corrosion process of reinforced concrete structure using FBG strain sensor,” IEEE Trans. Intrum. Meas. 66, 2148–2155 (2017).   
98. R. Li, “Sensitivity enhancement of FBG-based strain sensor,” Sensors 18, 1607 (2018).   
99. J. Peng et al., “Design and investigation of a sensitivity-enhanced fiber Bragg grating sensor for micro-strain measurement,” Sens. Actuators, A Phys. 285, 437–447 (2019).   
100. N. Beverini et al., “Fiber laser strain sensor device,” J. Opt. A Pure Appl. Opt. 9, 958–962 (2007).   
101. L. Shao et al., “High-resolution strain and temperature sensor based on distributed bragg reflector fiber laser,” IEEE Photonics Technol. Lett. 19(20), 1598–1600 (2007).   
102. K. Yu et al., “Fiber laser sensor for simultaneously axial strain and transverse load detection,” Measurement 62, 137–141 (2014).   
103. H. Chang et al., “In-fiber long-period grating and fiber Bragg grating-based sensor for simultaneously monitoring remote temperature and stress,” Sens. Mater. 30(1), 23–32 (2018).   
104. J. Xia et al., “Simultaneous measurements of distributed temperature and discrete strain based on hybrid Raman/FBG system,” Sens. Actuators A. Phys. 296, 235–240 (2019).   
105. A. K. Singh et al., “Simultaneous strain and temperature measurement using a single fiber Bragg grating embedded in a composite laminate,” Smart Mater. Struct. 26, 1–10 (2017).   
106. J. Du and Z. He, “Sensitivity enhanced strain and temperature measurements based on FBG and frequency chirp magnification,” Opt. Express 21(22), 27111–27118 (2013).   
107. S. Trpkovski et al., “Simultaneous load and temperature measurement using Lophinecoated fiber Bragg gratings,” Smart Mater. Struct. 25, 115019 (2016).   
108. W. Wu and X. Liu, “Investigation on high temperature characteristics of FBG sensors,” Optik (Stuttg). 126(20), 2411–2413 (2015).   
109. Y. Huang, F. Azarmi, and M. S. Jazi, “Composite coatings for fibre Bragg grating sensor in high temperature environments,” Int. J. Sens. Sens. Networks 3(2), 12–17 (2015).   
110. X. Pan et al., “Enhanced FBG temperature sensitivity in PbS-doped silica optical fiber,” J. Lightwave Technol. 37(18), 4902–4907 (2019).   
111. S. Ju, P. R. Watekar, and W. Han, “Enhanced sensitivity of the FBG temperature sensor based on the $\mathrm { P b O - G e O } _ { 2 } { \cdot } \mathrm { S i O } _ { 2 }$ glass optical fiber,” J. Lightwave Technol. 28(18), 2697–2700 (2020).   
112. C. Molardi et al., “Fiber Bragg grating (FBG) sensors in a high-scattering optical fiber doped with $\mathbf { M g O }$ nanoparticles for polarization-dependent temperature sensing,” Appl. Sci. 9, 3107 (2019).   
113. S. J. Mihailov, “Fiber Bragg grating sensors for harsh environments,” Sensors 12, 1898–1918 (2012).   
114. M. Rosenberger et al., “High temperature stable polymer planar waveguide Bragg grating sensors,” in IEEE 7th Int. Conf. Photonics (ICP), pp. 1–3 (2018).   
115. S. Korganbayev et al., “Thermal profile detection through high-sensitivity fiber optic chirped Bragg grating on microstructured PMMA fiber,” J. Lightwave Technol. 14(8), 1–7 (2018).   
116. M. Girschikofsky et al., “Waveguide Bragg gratings in Ormocer ${  { \mathbb { B } } _ { \mathrm { S } } }$ for temperature sensing,” Sensors 17, 2459 (2017).   
117. K. Cook et al., “Technologies for high temperature fibre Bragg grating (FBG) sensors,” pp. 2–5, https://technicasa.com/technologies-high-temperature-fibre-bragg-grating-fbgsensors/ (2007).   
118. M. Busch, W. Ecke, and I. Latka, “Multiplexed regenerated fiber Bragg gratings for hightemperature,” Meas. Sci. Technol. 24, 094010 (2013).   
119. F. Yu, “Regenerated fiber Bragg grating sensing system for ultrasonic detection in a $9 0 0 ^ { \circ } \mathrm { C }$ environment,” J. Nondestruct. Eval. Diagn. Progn. Eng. Syst. 2(1), 1–8 (2019).   
120. S. Ang et al., “Fiber Bragg grating fabricated in micro-single-crystal sapphire fiber,” Opt. Lett. 43(1), 62–65 (2018).   
121. S. Yang et al., “Application of sapphire-fiber-Bragg-grating-based multi-point temperature sensor in boilers at a commercial power plant,” Sensors 19, 3211 (2019).   
122. L. Wang et al., “A high spatial resolution FBG sensor array for measuring ocean temperature and depth,” Photonic Sens. 10, 57–66 (2020).   
123. R. Rajini-kumar et al., “Performance evaluation of metal-coated fiber Bragg grating sensors for sensing cryogenic temperature,” Cryogenics (Guildf). 48, 142–147 (2008).   
124. M. Wu, R. H. Pater, and S. L. Dehaven, “Effects of coating and diametric load on fiber Bragg gratings as cryogenic temperature sensors,” Proc. SPIE 6933, 693303 (2019).   
125. R. Rajinikumar et al., “Design parameter evaluation of a metal recoated fiber Bragg grating sensors for measurement of cryogenic temperature or stress in superconducting devices,” Cryogenics (Guildf). 49(5), 202–209 (2009).   
126. M. Sugino et al., “Development of zinc coating methods on fiber Bragg grating temperature sensors,” IEEE Trans. Appl. Supercond. 26(3), 1–6 (2016).   
127. C. Lupi et al., “Improving FBG sensor sensitivity at cryogenic temperature by metal coating,” IEEE Sens. J. 8(7), 1299–1304 (2008).   
128. A. W. Gao et al., “Investigation on sensing characteristics of fiber Bragg gratings based on soft glass fibers,” Opt. – Int. J. Light Electron Opt. 156, 13–21 (2017). gratings,” J. Mod. Opt. 65(7), 830–836 (2018).   
130. A. Fuerbach, G. Bharathan, and M. Ams, “Grating inscription into fluoride fibers?: a review,” IEEE Photonics J. 11(5), 1–12 (2019).   
131. C. Lai et al., “Application of fiber Bragg grating level sensor and Fabry-Pérot pressure sensor to simultaneous measurement of liquid level and specific gravity,” IEEE Sens. J. 12(4), 827 831 (2012).   
132. S. Yang, “Extrinsic Fabry–Perot cavity optical fiber liquid-level sensor,” Appl. Opt. 46(18), 1–6 (2007).   
133. D. Sengupta, M. S. Shankar, and K. Srimannarayana, “Hydrostatic pressure based liquid level sensing using FBG?: a comparative study,” Proc. SPIE 8769, 87691X (2013).   
134. C. A. R. Díaz et al., “Liquid level measurement based on FBG-embedded diaphragms with temperature compensation,” IEEE Sens. J. 18(1), 193–200 (2018).   
135. T. Osuch et al., “Simultaneous measurement of liquid level and temperature using tilted fiber Bragg grating,” IEEE Sens. J. 16(5), 1205–1209 (2016).   
136. H. Chang et al., “An ultra-sensitive liquid-level indicator based on an etched chirped-fiber Bragg grating,” IEEE Photonics Technol. Lett. 28(3), 268–271 (2016).   
137. R. Oliveira, S. Aristilde, and J. H. Os, “Intensity liquid level sensor based on multimode interference and fiber Bragg grating,” Meas. Sci. Technol. 27(12), 125104 (2016).   
138. C. Yu, L. Xia, and H. Yi, “Liquid level sensing application based on optical chaos,” in 15th Int. Conf. Opt. Commun. and Networks (ICOCN), pp. 1–3 (2016).   
139. G. B. Hocker, “Fiber-optic sensing of pressure and temperature,” Appl. Opt. 18(9), 1445–1448 (1979).   
140. J. B. Rosolem et al., “Electroless nickel-plating sealing in FBG pressure sensor for thermoelectric power plant engines applications,” J. Lightwave Technol. 37(18), 4791–4798 (2019).   
141. P. F. Liu et al., “A study of the development and application of fiber Bragg grating pressure sensors,” in Acad. Int. Symp. Optoelectron. and Microelectron. Technol., AISOMT 2011, pp. 232–235 (2011).   
142. Y. Haseda et al., “Measurement of pulse wave signals and blood pressure by a plastic optical fiber FBG sensor,” Sensors 19, 5088 (2019).   
143. P. Roriz, A. B. L. Ribeiro, and U. F. Pessoa, “Review of fiber-optic pressure sensors for biomedical and biomechanical applications,” J. Biomed. Opt. 18(5), 050903 (2013).   
144. P.-L. Ko, K.-C. Chuang, and C.-C. Ma, “A fiber Bragg grating-based thin-film sensor for measuring dynamic water pressure,” IEEE Sens. J. 18(18), 7383–7391 (2018).   
145. J. Huang et al., “A fiber Bragg grating pressure sensor and its application to pipeline leakage detection,” Adv. Mech. Eng. 5, 1–6 (2013).   
146. C. Hong et al., “A simple FBG pressure sensor fabricated using fused deposition modelling process,” Sens. Actuators A Phys. 285, 269–274 (2019).   
147. Y. Zheng et al., “Review and comparative study of strain-displacement conversion methods used in fiber Bragg grating-based inclinometers,” Measurement 137, 28–38 (2019).   
148. L. Kang, D. Kim, and J. Han, “Estimation of dynamic structural displacements using fiber Bragg grating strain sensors,” J. Sound Vib. 305(3), 534–542 (2007).   
149. C. Hong et al., “A FBG based displacement transducer for small soil deformation measurement,” Sens. Actuators A Phys. 286, 35–42 (2019).   
150. M. Bonopera et al., “Fiber Bragg grating—differential settlement measurement system for bridge displacement monitoring?: case study,” J. Bridge Eng. 24(10), 05019011 (2019).   
151. J. Johny et al., “Theoretical investigation of positional influence of FBG sensors for structural health monitoring of offshore structures,” in OCEANS 2017—Aberdeen, pp. 1–5 (2017).   
152. A. G. Leal-Junior et al., “Quasi-distributed torque and displacement sensing on a series elastic actuator’s spring using FBG arrays inscribed in CYTOP fibers,” IEEE Sens. J. 19(11), 4054–4061 (2019).   
153. P. W. Kong et al., “Fiber Bragg grating sensors for clinical measurement of the first metatarsophalangeal joint quasi-stiffness,” IEEE Sens. J. 20, 1322–1328 (2019).   
154. Y. Zhang et al., “Ultrahigh-resolution wavelength scanning system with FBG Fabry-Perot interferometer for displacement sensing,” in 16th Int. Conf. Opt. Commun. Networks (ICOCN) Ultrahigh-Resolut., pp. 16–18 (2017).   
155. T. Li, C. Shi, and H. Ren, “A novel fiber Bragg grating displacement sensor with a submicrometer resolution,” IEEE Photonics Technol. Lett. 29(14), 1199–1202 (2017).   
156. L. Xiong et al., “Fiber Bragg grating displacement sensor with high measurement accuracy for crack monitoring,” IEEE Sens. J. 19(22), 10506–10512 (2019).   
157. H. Meng et al., “A novel fiber Bragg grating displacement sensor,” Proc. SPIE 4595, 192–195 (2001).   
158. M. Amanzadeh et al., “Recent developments in fibre optic shape sensing,” Measurement 128(April), 119–137 (2018).   
159. X. Chen et al., “Updated shape sensing algorithm for space curves with FBG sensors,” Opt. Lasers Eng. 129, 106057 (2020).   
160. X. C. Y. Zhang and L. S. J. Qian, “Fabrication and shape detection of a catheter using fiber Bragg grating,” Adv. Manuf. 8(1), 107–118 (2020).   
161. H. Moon et al., “Fiber-Bragg-grating-based ultrathin shape sensors displaying singlechannel sweeping for minimally invasive surgery,” Opt. Lasers Eng. 59, 50–55 (2014).   
162. F. Khan et al., “Multi-core optical fibers with Bragg gratings as shape sensor for flexible medical instruments,” IEEE Sens. J. 19(14), 5878–5884 (2019).   
163. J. P. Moore and M. D. Rogge, “Shape sensing using multi-core fiber optic cable and parametric curve solutions,” Opt. Express 20(3), 2967–2973 (2012).   
164. J. Cui et al., “Parallel transport frame for fiber shape sensing,” IEEE Photonics J. 10, 1–13 (2017).   
165. R. J. Roesthuis et al., “Three-dimensional needle shape reconstruction using an array of fiber Bragg grating sensors,” IEEE/ASME Trans. Mechatron. 19(4), 1115–1126 (2014).   
166. S. Jäckle et al., “Fiber optical shape sensing of flexible instruments for endovascular navigation,” Int. J. Comput. Assist. Radiol. Surg. 14(12), 2137–2145 (2019).   
167. K. I. B. Ronnikov et al., “Durable shape sensor based on FBG array inscribed in polyimidecoated multicore optical fiber,” Opt. Express 27(26), 38421–38434 (2019).   
168. H. Wang et al., “Shape detection algorithm for soft manipulator based on fiber Bragg gratings,” IEEE/ASME Trans. Mechatronics 21(6), 2977–2982 (2016).   
169. M. Liang, X. Fang, and Y. Ning, “Temperature compensation fiber Bragg grating pressure sensor based on plane diaphragm,” Photonic Sens. 8(2), 157–167 (2018).   
170. L. Xiong et al., “Investigation of the temperature compensation of FBGs encapsulated with different methods and subjected to different temperature change rates,” J. Lightwave Technol. 37(3), 917–926 (2019).   
171. U. Tiwari, K. Thyagarajan, and M. R. Shenoy, “Optik strain and temperature discrimination technique by use of a FBG written in erbium doped fiber,” Opt.—Int. J. Light Electron Opt. 125(1), 235–237 (2014).   
172. Y. S. Hsu et al., “Temperature compensation of optical fiber Bragg grating pressure sensor,” IEEE Photonics Technol. Lett. 18(7), 874–876 (2006).   
173. A. Al-Zaben, M. Al Bataineh, and S. Al-Refaie, “Temperature compensation of fiber Bragg gratings manometry catheter using Kalman filter,” Int. J. Pharm. Med. Biol. Sci. 5, 12–16 (2016).   
174. M. Châu et al., “Passive temperature-compensating technique for microstructured fiber Bragg gratings,” IEEE Sens. J. 8(7), 1073–1078 (2008).   
175. K. Tian, Y. Liu, and Q. Wang, “Temperature-independent fiber Bragg grating strain sensor using bimetal cantilever,” Opt. Fiber Technol. 11, 370–377 (2005).   
176. J. Li et al., “Etching Bragg gratings in Panda fibers for the temperature-independent refractive index sensing,” Opt. Express 22(26), 1433–1435 (2014).   
177. Q. Wu et al., “Fiber refractometer based on a fiber Bragg grating and single-mode– multimode–single-mode fiber structure,” Opt. Lett. 36(12), 10–13 (2011).   
178. X. Li et al., “Simultaneous measurement of temperature and refractive index using an exposed core microstructured optical fiber,” IEEE J. Sel. Top. Quantum Electron. 26(4), 1–7 (2020).   
179. P. Xue et al., “Investigation of a D-shaped plastic optical fiber assisted by a long period grating for refractive index sensing,” IEEE Sens. J. 20(2), 842–847 (2020).   
180. C. Markos et al., “High-T g TOPAS microstructured polymer optical fiber for fiber Bragg grating strain sensing at 110 degrees,” Opt. Express 21(4), 660–662 (2013).   
181. G. Guo, M. Pankow, and K. Peters, “High-speed interrogation approach for FBG sensors using a VCSEL array swept source,” IEEE Sens. J. 19(21), 9766–9774 (2019).   
182. C. Kim, “A fiber Bragg grating sensor interrogation system based on a linearly wavelengthswept thermo-optic laser chip,” Sensors 14, 16109–16116 (2014).   
183. H. Zou, D. Liang, and J. Zeng, “Dynamic strain measurement using two wavelengthmatched fiber Bragg grating sensors interrogated by a cascaded long-period fiber grating,” Opt. Lasers Eng. 50, 199–203 (2012).   
184. D. Srivastava, U. Tiwari, and B. Das, “Interferometric interrogation of $\pi$ -phase shifted fiber Bragg grating sensors,” Opt. Commun. 410, 88–93 (2018).   
185. X. Zuowei, X. Shu, and F. Hongyan, “Fiber Bragg grating sensor interrogation system based on an optoelectronic oscillator loop,” Opt. Express 27(16), 23274–23281 (2019).   
186. Z. Ding et al., “A fast interrogation system of FBG sensors based on low loss jammed-array wideband sawtooth filter,” Opt. Fiber Technol. 48, 128–133 (2019).   
187. F. Xiao et al., “Estimation of vehicle-induced bridge dynamic responses using fiber Bragg grating strain gages,” Sci. Prog. 103(1), 1–14 (2020).   
188. Y. Cheng et al., “Derrick safety monitoring system based on fiber Bragg grating strain sensors,” Photonic Sens. 3(3), 237–240 (2015).   
189. J. Kong et al., “Simultaneous strain and directional bending sensor based on eccentric-core fiber Bragg grating,” in 25th Int. Conf. Opt. Fiber Sens., Vol. 10323, pp. 1–4 (2017).   
190. W. Shen et al., “Application study on FBG sensor applied to hull structural health monitoring,” Optik (Stuttg). 126(17), 1499–1504 (2015).   
191. H. L. Liu et al., “Experimental study on an FBG strain sensor,” Opt. Fiber Technol. 40, 144–151 (2018).   
192. Y. Yang et al., “A new fiber Bragg grating sensor based circumferential strain sensor fabricated using 3D printing method,” Sens. Actuators A. Phys. 295, 663–670 (2019).   
193. F. Ren et al., “The temperature compensation of FBG sensor for monitoring the stress on hole-edge,” IEEE Photonics J. 10(4), 1–9 (2018).   
194. Y. Wang et al., “Fiber Bragg gratings in small-core Ge-doped photonic crystal fibers,” J. Electron. Sci. Technol. China 6(4), 429–433 (2008).   
195. S. A. Sokan, “Temperature sensor based on multi-layer $\mathbf { M o S } _ { 2 }$ coated etched fiber Bragg grating,” Appl. Opt. 58(3), 535–539 (2019).   
196. T. Habisreuther et al., “Sapphire fiber Bragg gratings for high temperature and dynamic temperature diagnostics,” Appl. Therm. Eng. 91, 860–865 (2015).   
197. F. Huang et al., “Fiber laser based on a fiber Bragg grating and its application in hightemperature sensing,” Opt. Commun. 452(28), 233–237 (2019).   
198. F. Ahmed and M. B. G. Jun, “Microfiber Bragg grating sandwiched between standard optical fibers for enhanced temperature sensing,” IEEE Photonics Technol. Lett. 28(6), 685–688 (2016).   
199. B. B. Padhy, R. B. Sharma, and A. D. Shaligram, “Fiber Bragg grating temperature sensor with enhanced sensitivity,” Int. Res. J. Nat. Appl. Sci. 3(4), 78–87 (2016).   
200. Z. M. Hafizi et al., “High-resolution fibre Bragg grating (FBG) pressure transducer for low-pressure detection,” Int. J. Automot. Mech. Eng. 16(2), 6783–6795 (2019).   
201. W. T. Zhang et al., “Ultrathin FBG pressure sensor with enhanced responsitivity,” IEEE Photonics Technol. Lett. 19(19), 1553–1555 (2007).   
202. C. M. Jewart et al., “Ultrafast femtosecond-laser-induced fiber Bragg gratings in air-hole microstructured fibers for high-temperature pressure sensing,” Opt. Lett. 35(9), 1443–1445 (2010).   
203. S. Silva et al., “Hydrogen pressure sensor based on a tapered-FBG written by DUV femtosecond laser technique,” in Adv. Photonics Congr., OSA Technical Digest, pp. 5–6 (2012).   
204. H. Zhu et al., “Monitoring internal displacements of a model dam using FBG sensing bars,” Adv. Struct. Eng. 13(2), 249–261 (2010).   
205. K. Tian et al., “Simultaneous measurement of displacement and temperature based on a balloon-shaped bent SMF structure incorporating an LPG,” J. Lightwave Technol. 36(20), 4960–4966 (2018).   
206. A. S. G. Prasad and S. Asokan, “Fiber Bragg grating sensor package for submicron level displacement measurements,” Exp. Tech. 39, 19–24 (2015).

Jasjot K. Sahota is a PhD research scholar at Punjab Engineering College (Deemed to be University), Chandigarh. She received her BE degree in electronics and communication engineering from U.I.E.T., Panjab University, in 2014 and her MTech degree in electronics and communication engineering from Punjab Engineering College (Deemed to be University), Chandigarh, in 2017. Her area of research includes optical sensing and communication. She has contributed in a few scientific journals.

Neena Gupta is a professor in the Electronics and Communication Engineering Department at Punjab Engineering College (Deemed to be University), Chandigarh. She is a senior member of IEEE and has a vast teaching and research experience. She received her BE degree in electronics and communication engineering in 1988 and her ME (electronics) degree from Punjab University in 1992. She received her PhD from Punjab University in 2002 in optical communication. Her research interests include optical communication. She has contributed in various journals and conferences.

Divya Dhawan is an associate professor in the Electronics and Communication Engineering Department at Punjab Engineering College (Deemed to be University), Chandigarh. She received her PhD in optical communication in 2017. Her research interests include optical OFDM, passive optical networks, digital system design, and optical sensors. She has a number of publications in optical communication. She is member of various technical societies, such as IEEE (Electronic Devices), ISTE, and IEI.